/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver.grpc;

import io.grpc.Compressor;
import io.grpc.CompressorRegistry;
import io.grpc.Decompressor;
import io.grpc.DecompressorRegistry;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.ServerCall;
import io.grpc.ServerCallHandler;
import io.helidon.common.buffers.BufferData;
import io.helidon.http.Header;
import io.helidon.http.HeaderName;
import io.helidon.http.HeaderNames;
import io.helidon.http.HeaderValues;
import io.helidon.http.Headers;
import io.helidon.http.HttpPrologue;
import io.helidon.http.Status;
import io.helidon.http.WritableHeaders;
import io.helidon.http.http2.Http2Flag;
import io.helidon.http.http2.Http2FrameData;
import io.helidon.http.http2.Http2FrameHeader;
import io.helidon.http.http2.Http2FrameTypes;
import io.helidon.http.http2.Http2Headers;
import io.helidon.http.http2.Http2RstStream;
import io.helidon.http.http2.Http2Settings;
import io.helidon.http.http2.Http2StreamState;
import io.helidon.http.http2.Http2StreamWriter;
import io.helidon.http.http2.Http2WindowUpdate;
import io.helidon.http.http2.StreamFlowControl;
import io.helidon.webserver.grpc.Grpc;
import io.helidon.webserver.grpc.GrpcHeadersUtil;
import io.helidon.webserver.grpc.GrpcStatus;
import io.helidon.webserver.http2.spi.Http2SubProtocolSelector;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;

class GrpcProtocolHandler<REQ, RES>
implements Http2SubProtocolSelector.SubProtocolHandler {
    private static final System.Logger LOGGER = System.getLogger(GrpcProtocolHandler.class.getName());
    private static final HeaderName GRPC_ENCODING = HeaderNames.create((String)"grpc-encoding");
    private static final HeaderName GRPC_ACCEPT_ENCODING = HeaderNames.create((String)"grpc-accept-encoding");
    private static final Header GRPC_CONTENT_TYPE = HeaderValues.createCached((HeaderName)HeaderNames.CONTENT_TYPE, (String)"application/grpc");
    private static final Header GRPC_ENCODING_IDENTITY = HeaderValues.createCached((HeaderName)GRPC_ENCODING, (String)"identity");
    private static final Http2Flag.DataFlags DATA_FLAGS_ZERO = Http2Flag.DataFlags.create((int)0);
    private static final DecompressorRegistry DECOMPRESSOR_REGISTRY = DecompressorRegistry.getDefaultInstance();
    private static final CompressorRegistry COMPRESSOR_REGISTRY = CompressorRegistry.getDefaultInstance();
    private final HttpPrologue prologue;
    private final Http2Headers headers;
    private final Http2StreamWriter streamWriter;
    private final int streamId;
    private final Http2Settings serverSettings;
    private final Http2Settings clientSettings;
    private final Grpc<REQ, RES> route;
    private final AtomicInteger numMessages = new AtomicInteger();
    private final LinkedBlockingQueue<REQ> listenerQueue = new LinkedBlockingQueue();
    private final StreamFlowControl flowControl;
    private Http2StreamState currentStreamState;
    private ServerCall.Listener<REQ> listener;
    private BufferData entityBytes;
    private Compressor compressor;
    private Decompressor decompressor;

    GrpcProtocolHandler(HttpPrologue prologue, Http2Headers headers, Http2StreamWriter streamWriter, int streamId, Http2Settings serverSettings, Http2Settings clientSettings, StreamFlowControl flowControl, Http2StreamState currentStreamState, Grpc<REQ, RES> route) {
        this.prologue = prologue;
        this.headers = headers;
        this.streamWriter = streamWriter;
        this.streamId = streamId;
        this.serverSettings = serverSettings;
        this.clientSettings = clientSettings;
        this.flowControl = flowControl;
        this.currentStreamState = currentStreamState;
        this.route = route;
    }

    public void init() {
        try {
            ServerCall<REQ, RES> serverCall = this.createServerCall();
            Headers httpHeaders = this.headers.httpHeaders();
            if (httpHeaders.contains(GRPC_ENCODING)) {
                Header grpcEncoding = httpHeaders.get(GRPC_ENCODING);
                String encoding = (String)grpcEncoding.asString().get();
                this.decompressor = DECOMPRESSOR_REGISTRY.lookupDecompressor(encoding);
                this.compressor = COMPRESSOR_REGISTRY.lookupCompressor(encoding);
                if (this.decompressor == null || this.compressor == null) {
                    Metadata metadata = new Metadata();
                    Set encodings = DECOMPRESSOR_REGISTRY.getAdvertisedMessageEncodings();
                    metadata.put(Metadata.Key.of((String)GRPC_ACCEPT_ENCODING.defaultCase(), (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER), (Object)String.join((CharSequence)",", encodings));
                    serverCall.close(io.grpc.Status.UNIMPLEMENTED, metadata);
                    this.currentStreamState = Http2StreamState.CLOSED;
                    return;
                }
            } else if (httpHeaders.contains(GRPC_ACCEPT_ENCODING)) {
                Header acceptEncoding = httpHeaders.get(GRPC_ACCEPT_ENCODING);
                for (String encoding : acceptEncoding.allValues()) {
                    this.compressor = COMPRESSOR_REGISTRY.lookupCompressor(encoding);
                    if (this.compressor == null) continue;
                    this.decompressor = DECOMPRESSOR_REGISTRY.lookupDecompressor(encoding);
                    if (this.decompressor != null) break;
                    this.compressor = null;
                }
            }
            ServerCallHandler<REQ, RES> callHandler = this.route.callHandler();
            this.listener = callHandler.startCall(serverCall, GrpcHeadersUtil.toMetadata(this.headers));
            this.listener.onReady();
        }
        catch (Throwable e) {
            LOGGER.log(System.Logger.Level.ERROR, "Failed to initialize grpc protocol handler", e);
            throw e;
        }
    }

    private void addNumMessages(int n) {
        this.numMessages.getAndAdd(n);
    }

    public Http2StreamState streamState() {
        return this.currentStreamState;
    }

    public void rstStream(Http2RstStream rstStream) {
        this.listener.onComplete();
    }

    public void windowUpdate(Http2WindowUpdate update) {
    }

    public void data(Http2FrameHeader header, BufferData data) {
        try {
            boolean isCompressed = false;
            while (data.available() > 0) {
                if (this.entityBytes == null) {
                    isCompressed = data.read() == 1;
                    long length = data.readUnsignedInt32();
                    this.entityBytes = BufferData.create((int)((int)length));
                }
                this.entityBytes.write(data);
                if (this.entityBytes.capacity() != 0) continue;
                if (isCompressed && this.decompressor == null) {
                    throw new IllegalStateException("Unable to codec for compressed data");
                }
                byte[] bytes = new byte[this.entityBytes.available()];
                this.entityBytes.read(bytes);
                ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
                Object request = this.route.method().parseRequest(isCompressed ? this.decompressor.decompress((InputStream)bais) : bais);
                this.listenerQueue.add(request);
                this.flushQueue();
                this.entityBytes = null;
            }
            if (((Http2Flag.DataFlags)header.flags(Http2FrameTypes.DATA)).endOfStream()) {
                this.listener.onHalfClose();
                this.currentStreamState = Http2StreamState.HALF_CLOSED_LOCAL;
            }
        }
        catch (Exception e) {
            this.listener.onCancel();
            LOGGER.log(System.Logger.Level.ERROR, "Failed to process grpc request: " + data.debugDataHex(true), (Throwable)e);
        }
    }

    private void flushQueue() {
        if (this.listener != null) {
            while (!this.listenerQueue.isEmpty() && this.numMessages.getAndDecrement() > 0) {
                this.listener.onMessage(this.listenerQueue.poll());
            }
        }
    }

    private ServerCall<REQ, RES> createServerCall() {
        return new ServerCall<REQ, RES>(){

            public void request(int numMessages) {
                GrpcProtocolHandler.this.addNumMessages(numMessages);
                GrpcProtocolHandler.this.flushQueue();
            }

            public void sendHeaders(Metadata headers) {
                WritableHeaders writable = WritableHeaders.create();
                GrpcHeadersUtil.updateHeaders(writable, headers);
                writable.set(GRPC_CONTENT_TYPE);
                if (GrpcProtocolHandler.this.compressor == null) {
                    writable.set(GRPC_ENCODING_IDENTITY);
                } else {
                    writable.set(HeaderValues.createCached((HeaderName)GRPC_ENCODING, (String)GrpcProtocolHandler.this.compressor.getMessageEncoding()));
                }
                Http2Headers http2Headers = Http2Headers.create((WritableHeaders)writable);
                http2Headers.status(Status.OK_200);
                GrpcProtocolHandler.this.streamWriter.writeHeaders(http2Headers, GrpcProtocolHandler.this.streamId, Http2Flag.HeaderFlags.create((int)4), GrpcProtocolHandler.this.flowControl.outbound());
            }

            public void sendMessage(RES message) {
                try (InputStream inputStream = GrpcProtocolHandler.this.route.method().streamResponse(message);){
                    BufferData bufferData;
                    if (GrpcProtocolHandler.this.compressor == null) {
                        byte[] bytes = inputStream.readAllBytes();
                        bufferData = BufferData.create((int)(5 + bytes.length));
                        bufferData.write(0);
                        bufferData.writeUnsignedInt32((long)bytes.length);
                        bufferData.write(bytes);
                    } else {
                        ByteArrayOutputStream baos = new ByteArrayOutputStream();
                        try (OutputStream os = GrpcProtocolHandler.this.compressor.compress((OutputStream)baos);){
                            inputStream.transferTo(os);
                        }
                        byte[] bytes = baos.toByteArray();
                        bufferData = BufferData.create((int)(5 + bytes.length));
                        bufferData.write(1);
                        bufferData.writeUnsignedInt32((long)bytes.length);
                        bufferData.write(bytes);
                    }
                    Http2FrameHeader header = Http2FrameHeader.create((int)bufferData.available(), (Http2FrameTypes)Http2FrameTypes.DATA, (Http2Flag)DATA_FLAGS_ZERO, (int)GrpcProtocolHandler.this.streamId);
                    GrpcProtocolHandler.this.streamWriter.writeData(new Http2FrameData(header, bufferData), GrpcProtocolHandler.this.flowControl.outbound());
                }
                catch (Exception e) {
                    GrpcProtocolHandler.this.listener.onCancel();
                    LOGGER.log(System.Logger.Level.ERROR, "Failed to respond to grpc request: " + String.valueOf(GrpcProtocolHandler.this.route.method()), (Throwable)e);
                }
            }

            public void close(io.grpc.Status status, Metadata trailers) {
                WritableHeaders writable = WritableHeaders.create();
                GrpcHeadersUtil.updateHeaders(writable, trailers);
                writable.set(HeaderValues.create((HeaderName)GrpcStatus.STATUS_NAME, (int)status.getCode().value()));
                String description = status.getDescription();
                if (description != null) {
                    writable.set(HeaderValues.create((HeaderName)GrpcStatus.MESSAGE_NAME, (String)description));
                }
                Http2Headers http2Headers = Http2Headers.create((WritableHeaders)writable);
                GrpcProtocolHandler.this.streamWriter.writeHeaders(http2Headers, GrpcProtocolHandler.this.streamId, Http2Flag.HeaderFlags.create((int)5), GrpcProtocolHandler.this.flowControl.outbound());
                GrpcProtocolHandler.this.currentStreamState = Http2StreamState.HALF_CLOSED_LOCAL;
            }

            public boolean isCancelled() {
                return GrpcProtocolHandler.this.currentStreamState == Http2StreamState.CLOSED;
            }

            public MethodDescriptor<REQ, RES> getMethodDescriptor() {
                return GrpcProtocolHandler.this.route.method();
            }
        };
    }
}

