/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver.grpc;

import io.grpc.Metadata;
import io.helidon.http.HeaderNames;
import io.helidon.http.WritableHeaders;
import io.helidon.http.http2.Http2Headers;
import java.nio.charset.StandardCharsets;
import java.util.Base64;

class GrpcHeadersUtil {
    private GrpcHeadersUtil() {
    }

    static void updateHeaders(WritableHeaders<?> writable, Metadata headers) {
        Base64.Encoder encoder = Base64.getEncoder();
        headers.keys().forEach(name -> {
            if (name.endsWith("-bin")) {
                byte[] binary = (byte[])headers.get(Metadata.Key.of((String)name, (Metadata.BinaryMarshaller)Metadata.BINARY_BYTE_MARSHALLER));
                writable.add(HeaderNames.create((String)name, (String)new String(encoder.encode(binary), StandardCharsets.US_ASCII)), new String[0]);
            } else {
                String ascii = (String)headers.get(Metadata.Key.of((String)name, (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER));
                writable.add(HeaderNames.create((String)name, (String)ascii), new String[0]);
            }
        });
    }

    static Metadata toMetadata(Http2Headers headers) {
        Base64.Decoder decoder = Base64.getDecoder();
        Metadata metadata = new Metadata();
        headers.httpHeaders().forEach(header -> {
            String name = header.name();
            if (name.endsWith("-bin")) {
                metadata.put(Metadata.Key.of((String)name, (Metadata.BinaryMarshaller)Metadata.BINARY_BYTE_MARSHALLER), (Object)decoder.decode(name.getBytes(StandardCharsets.US_ASCII)));
            } else {
                metadata.put(Metadata.Key.of((String)name, (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER), (Object)name);
            }
        });
        return metadata;
    }
}

