/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver.grpc;

import io.grpc.stub.StreamObserver;
import io.helidon.webserver.grpc.SafeStreamObserver;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Stream;

public final class ResponseHelper {
    private ResponseHelper() {
    }

    public static <T> void complete(StreamObserver<T> observer, T value) {
        StreamObserver<T> safe = SafeStreamObserver.ensureSafeObserver(observer);
        safe.onNext(value);
        safe.onCompleted();
    }

    public static <T> void complete(StreamObserver<T> observer, CompletionStage<T> future) {
        future.whenComplete(ResponseHelper.completeWithResult(observer));
    }

    public static <T> void completeAsync(StreamObserver<T> observer, CompletionStage<T> future) {
        future.whenCompleteAsync(ResponseHelper.completeWithResult(observer));
    }

    public static <T> void completeAsync(StreamObserver<T> observer, CompletionStage<T> future, Executor executor) {
        future.whenCompleteAsync(ResponseHelper.completeWithResult(observer), executor);
    }

    public static <T> void complete(StreamObserver<T> observer, Callable<T> callable) {
        try {
            observer.onNext(callable.call());
            observer.onCompleted();
        }
        catch (Throwable t) {
            observer.onError(t);
        }
    }

    public static <T> void completeAsync(StreamObserver<T> observer, Callable<T> callable) {
        ResponseHelper.completeAsync(observer, CompletableFuture.supplyAsync(ResponseHelper.createSupplier(callable)));
    }

    public static <T> void completeAsync(StreamObserver<T> observer, Callable<T> callable, Executor executor) {
        ResponseHelper.completeAsync(observer, CompletableFuture.supplyAsync(ResponseHelper.createSupplier(callable), executor));
    }

    public static <T> void complete(StreamObserver<T> observer, Runnable task, T result) {
        ResponseHelper.complete(observer, Executors.callable(task, result));
    }

    public static <T> void completeAsync(StreamObserver<T> observer, Runnable task, T result) {
        ResponseHelper.completeAsync(observer, Executors.callable(task, result));
    }

    public static <T> void completeAsync(StreamObserver<T> observer, Runnable task, T result, Executor executor) {
        ResponseHelper.completeAsync(observer, Executors.callable(task, result), executor);
    }

    public static <T> void stream(StreamObserver<T> observer, Stream<? extends T> stream) {
        ResponseHelper.stream(observer, () -> stream);
    }

    public static <T> void streamAsync(StreamObserver<T> observer, Stream<? extends T> stream, Executor executor) {
        executor.execute(() -> ResponseHelper.stream(observer, () -> stream));
    }

    public static <T> void stream(StreamObserver<T> observer, Supplier<Stream<? extends T>> supplier) {
        StreamObserver<T> safe = SafeStreamObserver.ensureSafeObserver(observer);
        Throwable thrown = null;
        try {
            supplier.get().forEach(arg_0 -> safe.onNext(arg_0));
        }
        catch (Throwable t) {
            thrown = t;
        }
        if (thrown == null) {
            safe.onCompleted();
        } else {
            safe.onError(thrown);
        }
    }

    public static <T> void streamAsync(StreamObserver<T> observer, Supplier<Stream<? extends T>> supplier, Executor executor) {
        executor.execute(() -> ResponseHelper.stream(observer, supplier));
    }

    public static <T> Consumer<T> stream(StreamObserver<T> observer, CompletionStage<Void> stage) {
        StreamObserver<T> safe = SafeStreamObserver.ensureSafeObserver(observer);
        stage.whenComplete(ResponseHelper.completeWithoutResult(safe));
        return arg_0 -> safe.onNext(arg_0);
    }

    public static <T> Consumer<T> streamAsync(StreamObserver<T> observer, CompletionStage<Void> stage) {
        StreamObserver safe = SafeStreamObserver.ensureSafeObserver(observer);
        stage.whenCompleteAsync(ResponseHelper.completeWithoutResult(safe));
        return value -> CompletableFuture.runAsync(() -> safe.onNext(value));
    }

    public static <T> Consumer<T> streamAsync(StreamObserver<T> observer, CompletionStage<Void> stage, Executor executor) {
        StreamObserver safe = SafeStreamObserver.ensureSafeObserver(observer);
        stage.whenCompleteAsync(ResponseHelper.completeWithoutResult(safe), executor);
        return value -> CompletableFuture.runAsync(() -> safe.onNext(value), executor);
    }

    public static <T, U> BiConsumer<T, Throwable> completeWithResult(StreamObserver<U> observer) {
        return new CompletionAction(observer, true);
    }

    public static <U> BiConsumer<Void, Throwable> completeWithoutResult(StreamObserver<U> observer) {
        return new CompletionAction(observer, false);
    }

    public static <T> Supplier<T> createSupplier(Callable<T> callable) {
        return new CallableSupplier<T>(callable);
    }

    private static class CompletionAction<T, U>
    implements BiConsumer<T, Throwable> {
        private StreamObserver<U> observer;
        private boolean sendResult;

        CompletionAction(StreamObserver<U> observer, boolean sendResult) {
            this.observer = observer;
            this.sendResult = sendResult;
        }

        @Override
        public void accept(T result, Throwable error) {
            if (error != null) {
                this.observer.onError(error);
            } else {
                if (this.sendResult) {
                    this.observer.onNext(result);
                }
                this.observer.onCompleted();
            }
        }
    }

    private static class CallableSupplier<T>
    implements Supplier<T> {
        private Callable<T> callable;

        CallableSupplier(Callable<T> callable) {
            this.callable = callable;
        }

        @Override
        public T get() {
            try {
                return this.callable.call();
            }
            catch (Exception e) {
                throw new CompletionException(e.getMessage(), e);
            }
        }
    }
}

