/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver.grpc;

import com.google.protobuf.Descriptors;
import io.grpc.stub.ServerCalls;
import io.helidon.http.HttpPrologue;
import io.helidon.http.PathMatchers;
import io.helidon.webserver.grpc.Grpc;
import io.helidon.webserver.grpc.GrpcRoute;
import io.helidon.webserver.grpc.GrpcService;
import java.util.LinkedList;
import java.util.List;

class GrpcServiceRoute
extends GrpcRoute {
    private final String serviceName;
    private final List<Grpc<?, ?>> routes;

    private GrpcServiceRoute(String serviceName, List<Grpc<?, ?>> routes) {
        this.serviceName = serviceName;
        this.routes = routes;
    }

    static GrpcRoute create(GrpcService service) {
        Routing svcRouter = new Routing(service);
        service.update(svcRouter);
        return svcRouter.build();
    }

    @Override
    Grpc<?, ?> toGrpc(HttpPrologue prologue) {
        for (Grpc<?, ?> route : this.routes) {
            PathMatchers.MatchResult accepts = route.accepts(prologue);
            if (!accepts.accepted()) continue;
            return route;
        }
        throw new IllegalStateException("GrpcServiceRoute(" + this.serviceName + ") accepted prologue, but cannot provide route: " + String.valueOf(prologue));
    }

    @Override
    public PathMatchers.MatchResult accepts(HttpPrologue prologue) {
        for (Grpc<?, ?> route : this.routes) {
            PathMatchers.MatchResult accepts = route.accepts(prologue);
            if (!accepts.accepted()) continue;
            return accepts;
        }
        return PathMatchers.MatchResult.notAccepted();
    }

    static class Routing
    implements GrpcService.Routing {
        private final List<Grpc<?, ?>> routes = new LinkedList();
        private final Descriptors.FileDescriptor proto;
        private final String serviceName;

        Routing(GrpcService service) {
            this.proto = service.proto();
            this.serviceName = service.serviceName();
        }

        @Override
        public <ReqT, ResT> GrpcService.Routing unary(String methodName, ServerCalls.UnaryMethod<ReqT, ResT> method) {
            this.routes.add(Grpc.unary(this.proto, this.serviceName, methodName, method));
            return this;
        }

        @Override
        public <ReqT, ResT> GrpcService.Routing bidi(String methodName, ServerCalls.BidiStreamingMethod<ReqT, ResT> method) {
            this.routes.add(Grpc.bidi(this.proto, this.serviceName, methodName, method));
            return this;
        }

        @Override
        public <ReqT, ResT> GrpcService.Routing serverStream(String methodName, ServerCalls.ServerStreamingMethod<ReqT, ResT> method) {
            this.routes.add(Grpc.serverStream(this.proto, this.serviceName, methodName, method));
            return this;
        }

        @Override
        public <ReqT, ResT> GrpcService.Routing clientStream(String methodName, ServerCalls.ClientStreamingMethod<ReqT, ResT> method) {
            this.routes.add(Grpc.clientStream(this.proto, this.serviceName, methodName, method));
            return this;
        }

        public GrpcServiceRoute build() {
            return new GrpcServiceRoute(this.serviceName, List.copyOf(this.routes));
        }
    }
}

