/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver.grpc;

import io.helidon.http.HeaderNames;
import io.helidon.http.Headers;
import io.helidon.http.HttpPrologue;
import io.helidon.http.Method;
import io.helidon.http.http2.Http2Headers;
import io.helidon.http.http2.Http2Settings;
import io.helidon.http.http2.Http2StreamState;
import io.helidon.http.http2.Http2StreamWriter;
import io.helidon.http.http2.StreamFlowControl;
import io.helidon.webserver.ConnectionContext;
import io.helidon.webserver.Router;
import io.helidon.webserver.Routing;
import io.helidon.webserver.grpc.Grpc;
import io.helidon.webserver.grpc.GrpcProtocolHandler;
import io.helidon.webserver.grpc.GrpcProtocolHandlerNotFound;
import io.helidon.webserver.grpc.GrpcRouting;
import io.helidon.webserver.http2.spi.Http2SubProtocolSelector;
import io.helidon.webserver.http2.spi.SubProtocolResult;

public class GrpcProtocolSelector
implements Http2SubProtocolSelector {
    private GrpcProtocolSelector() {
    }

    public static GrpcProtocolSelector create() {
        return new GrpcProtocolSelector();
    }

    public SubProtocolResult subProtocol(ConnectionContext ctx, HttpPrologue prologue, Http2Headers headers, Http2StreamWriter streamWriter, int streamId, Http2Settings serverSettings, Http2Settings clientSettings, StreamFlowControl flowControl, Http2StreamState currentStreamState, Router router) {
        String contentType;
        if (prologue.method() != Method.POST) {
            return NOT_SUPPORTED;
        }
        Headers httpHeaders = headers.httpHeaders();
        if (httpHeaders.contains(HeaderNames.CONTENT_TYPE) && (contentType = httpHeaders.get(HeaderNames.CONTENT_TYPE).value()).startsWith("application/grpc")) {
            GrpcRouting routing = (GrpcRouting)router.routing(GrpcRouting.class, (Routing)GrpcRouting.empty());
            Grpc<?, ?> route = routing.findRoute(prologue);
            if (route == null) {
                return new SubProtocolResult(true, (Http2SubProtocolSelector.SubProtocolHandler)new GrpcProtocolHandlerNotFound(streamWriter, streamId, currentStreamState));
            }
            return new SubProtocolResult(true, new GrpcProtocolHandler(prologue, headers, streamWriter, streamId, serverSettings, clientSettings, flowControl, currentStreamState, route));
        }
        return NOT_SUPPORTED;
    }
}

