/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver.grpc;

import com.google.protobuf.DescriptorProtos;
import com.google.protobuf.Descriptors;
import io.grpc.MethodDescriptor;
import io.grpc.ServerCallHandler;
import io.grpc.ServerMethodDefinition;
import io.grpc.stub.ServerCalls;
import io.helidon.http.HttpPrologue;
import io.helidon.http.PathMatcher;
import io.helidon.http.PathMatchers;
import io.helidon.webserver.grpc.GrpcRoute;
import io.helidon.webserver.grpc.ProtoMarshaller;

class Grpc<ReqT, ResT>
extends GrpcRoute {
    private final MethodDescriptor<ReqT, ResT> method;
    private final PathMatcher pathMatcher;
    private final Class<ReqT> requestType;
    private final Class<ResT> responseType;
    private final ServerCallHandler<ReqT, ResT> callHandler;

    private Grpc(MethodDescriptor<ReqT, ResT> method, PathMatcher pathMatcher, Class<ReqT> requestType, Class<ResT> responseType, ServerCallHandler<ReqT, ResT> callHandler) {
        this.method = method;
        this.pathMatcher = pathMatcher;
        this.requestType = requestType;
        this.responseType = responseType;
        this.callHandler = callHandler;
    }

    static <ReqT, ResT> Grpc<ReqT, ResT> unary(Descriptors.FileDescriptor proto, String serviceName, String methodName, ServerCalls.UnaryMethod<ReqT, ResT> method) {
        return Grpc.grpc(proto, serviceName, methodName, ServerCalls.asyncUnaryCall(method));
    }

    static <ReqT, ResT> Grpc<ReqT, ResT> bidi(Descriptors.FileDescriptor proto, String serviceName, String methodName, ServerCalls.BidiStreamingMethod<ReqT, ResT> method) {
        return Grpc.grpc(proto, serviceName, methodName, ServerCalls.asyncBidiStreamingCall(method));
    }

    static <ReqT, ResT> Grpc<ReqT, ResT> serverStream(Descriptors.FileDescriptor proto, String serviceName, String methodName, ServerCalls.ServerStreamingMethod<ReqT, ResT> method) {
        return Grpc.grpc(proto, serviceName, methodName, ServerCalls.asyncServerStreamingCall(method));
    }

    static <ReqT, ResT> Grpc<ReqT, ResT> clientStream(Descriptors.FileDescriptor proto, String serviceName, String methodName, ServerCalls.ClientStreamingMethod<ReqT, ResT> method) {
        return Grpc.grpc(proto, serviceName, methodName, ServerCalls.asyncClientStreamingCall(method));
    }

    static <ReqT, ResT> Grpc<ReqT, ResT> methodDefinition(ServerMethodDefinition<ReqT, ResT> definition, Descriptors.FileDescriptor proto) {
        return Grpc.grpc(definition.getMethodDescriptor(), definition.getServerCallHandler(), proto);
    }

    @Override
    Grpc<?, ?> toGrpc(HttpPrologue grpcPrologue) {
        return this;
    }

    @Override
    PathMatchers.MatchResult accepts(HttpPrologue prologue) {
        return this.pathMatcher.match(prologue.uriPath());
    }

    MethodDescriptor<ReqT, ResT> method() {
        return this.method;
    }

    Class<ReqT> requestType() {
        return this.requestType;
    }

    Class<ResT> responseType() {
        return this.responseType;
    }

    ServerCallHandler<ReqT, ResT> callHandler() {
        return this.callHandler;
    }

    private static <ResT, ReqT> Grpc<ReqT, ResT> grpc(Descriptors.FileDescriptor proto, String serviceName, String methodName, ServerCallHandler<ReqT, ResT> callHandler) {
        Descriptors.ServiceDescriptor svc = proto.findServiceByName(serviceName);
        Descriptors.MethodDescriptor mtd = svc.findMethodByName(methodName);
        String path = svc.getFullName() + "/" + methodName;
        Class requestType = Grpc.load(Grpc.getClassName(mtd.getInputType()));
        Class responsetype = Grpc.load(Grpc.getClassName(mtd.getOutputType()));
        MethodDescriptor.Marshaller reqMarshaller = ProtoMarshaller.get(requestType);
        MethodDescriptor.Marshaller resMarshaller = ProtoMarshaller.get(responsetype);
        MethodDescriptor.Builder grpcDesc = MethodDescriptor.newBuilder().setFullMethodName(MethodDescriptor.generateFullMethodName((String)serviceName, (String)methodName)).setType(Grpc.getMethodType(mtd)).setFullMethodName(path).setRequestMarshaller(reqMarshaller).setResponseMarshaller(resMarshaller).setSampledToLocalTracing(true);
        return new Grpc(grpcDesc.build(), PathMatchers.exact((String)path), requestType, responsetype, callHandler);
    }

    private static <ResT, ReqT> Grpc<ReqT, ResT> grpc(MethodDescriptor<ReqT, ResT> grpcDesc, ServerCallHandler<ReqT, ResT> callHandler, Descriptors.FileDescriptor proto) {
        Class requestType = null;
        Class responsetype = null;
        String serviceName = grpcDesc.getServiceName();
        if (proto != null && serviceName != null) {
            Descriptors.ServiceDescriptor svc = proto.findServiceByName(serviceName);
            Descriptors.MethodDescriptor mtd = svc.findMethodByName(grpcDesc.getBareMethodName());
            requestType = Grpc.load(Grpc.getClassName(mtd.getInputType()));
            responsetype = Grpc.load(Grpc.getClassName(mtd.getOutputType()));
        }
        return new Grpc<ReqT, ResT>(grpcDesc, PathMatchers.exact((String)grpcDesc.getFullMethodName()), requestType, responsetype, callHandler);
    }

    private static String getClassName(Descriptors.Descriptor descriptor) {
        Descriptors.FileDescriptor fd = descriptor.getFile();
        String outerClass = Grpc.getOuterClass(fd);
        String pkg = fd.getOptions().getJavaPackage();
        pkg = "".equals(pkg) ? fd.getPackage() : pkg;
        return pkg + "." + outerClass + descriptor.getName().replace('.', '$');
    }

    private static <T> Class<T> load(String className) {
        try {
            return Grpc.class.getClassLoader().loadClass(className);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Failed to load class \"" + className + "\" for grpc", e);
        }
    }

    private static String getOuterClass(Descriptors.FileDescriptor proto) {
        DescriptorProtos.FileOptions options = proto.getOptions();
        if (options.getJavaMultipleFiles()) {
            return "";
        }
        String outerClass = options.getJavaOuterClassname();
        if ("".equals(outerClass)) {
            outerClass = Grpc.getOuterClassFromFileName(proto.getName());
        }
        return outerClass + "$";
    }

    private static String getOuterClassFromFileName(String name) {
        name = name.substring(0, name.lastIndexOf(".proto"));
        String[] words = name.split("_");
        StringBuilder sb = new StringBuilder(name.length());
        for (String word : words) {
            sb.append(Character.toUpperCase(word.charAt(0))).append(word.substring(1));
        }
        return sb.toString();
    }

    private static MethodDescriptor.MethodType getMethodType(Descriptors.MethodDescriptor mtd) {
        if (mtd.isClientStreaming()) {
            if (mtd.isServerStreaming()) {
                return MethodDescriptor.MethodType.BIDI_STREAMING;
            }
            return MethodDescriptor.MethodType.CLIENT_STREAMING;
        }
        if (mtd.isServerStreaming()) {
            return MethodDescriptor.MethodType.SERVER_STREAMING;
        }
        return MethodDescriptor.MethodType.UNARY;
    }
}

