/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver.graphql;

import graphql.schema.GraphQLSchema;
import io.helidon.common.GenericType;
import io.helidon.common.configurable.ServerThreadPoolSupplier;
import io.helidon.common.configurable.ThreadPoolConfig;
import io.helidon.common.media.type.MediaTypes;
import io.helidon.common.uri.UriQuery;
import io.helidon.config.Config;
import io.helidon.cors.CrossOriginConfig;
import io.helidon.graphql.server.InvocationHandler;
import io.helidon.webserver.cors.CorsEnabledServiceHelper;
import io.helidon.webserver.http.Handler;
import io.helidon.webserver.http.HttpRules;
import io.helidon.webserver.http.HttpService;
import io.helidon.webserver.http.ServerRequest;
import io.helidon.webserver.http.ServerResponse;
import jakarta.json.bind.Jsonb;
import jakarta.json.bind.JsonbBuilder;
import jakarta.json.bind.JsonbConfig;
import jakarta.json.bind.adapter.JsonbAdapter;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.function.Supplier;

public class GraphQlService
implements HttpService {
    private static final Jsonb JSONB = JsonbBuilder.newBuilder().withConfig(new JsonbConfig().setProperty("jsonb.zero-time-defaulting", (Object)true).withNullValues(Boolean.valueOf(true)).withAdapters(new JsonbAdapter[0])).build();
    private static final GenericType<LinkedHashMap> LINKED_HASH_MAP_GENERIC_TYPE = GenericType.create(LinkedHashMap.class);
    private final String context;
    private final String schemaUri;
    private final InvocationHandler invocationHandler;
    private final CorsEnabledServiceHelper corsEnabled;
    private final ExecutorService executor;

    private GraphQlService(Builder builder) {
        this.context = builder.context;
        this.schemaUri = builder.schemaUri;
        this.invocationHandler = builder.handler;
        this.corsEnabled = CorsEnabledServiceHelper.create((String)"GraphQL", (CrossOriginConfig)builder.crossOriginConfig);
        this.executor = builder.executor.get();
    }

    public static GraphQlService create(GraphQLSchema schema) {
        return GraphQlService.builder().invocationHandler(InvocationHandler.create((GraphQLSchema)schema)).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public void routing(HttpRules rules) {
        rules.any(this.context, new Handler[]{this.corsEnabled.processor()});
        rules.get(this.context + this.schemaUri, new Handler[]{this::graphQlSchema});
        rules.get(this.context, new Handler[]{this::graphQlGet}).post(this.context, new Handler[]{this::graphQlPost});
    }

    private void graphQlPost(ServerRequest req, ServerResponse res) {
        LinkedHashMap entity = (LinkedHashMap)JSONB.fromJson(req.content().inputStream(), LINKED_HASH_MAP_GENERIC_TYPE.type());
        this.processRequest(res, (String)entity.get("query"), (String)entity.get("operationName"), this.toVariableMap(entity.get("variables")));
    }

    private void graphQlGet(ServerRequest req, ServerResponse res) {
        UriQuery queryParams = req.query();
        String query = (String)queryParams.first("query").orElseThrow(() -> new IllegalStateException("Query must be defined"));
        String operationName = (String)queryParams.first("operationName").orElse(null);
        Map variables = queryParams.first("variables").map(this::toVariableMap).orElseGet(Map::of);
        this.processRequest(res, query, operationName, variables);
    }

    private void graphQlSchema(ServerRequest req, ServerResponse res) {
        res.send((Object)this.invocationHandler.schemaString());
    }

    private void processRequest(ServerResponse res, String query, String operationName, Map<String, Object> variables) {
        res.headers().contentType(MediaTypes.APPLICATION_JSON);
        res.send((Object)JSONB.toJson((Object)this.invocationHandler.execute(query, operationName, variables)));
    }

    private Map<String, Object> toVariableMap(Object variables) {
        if (variables == null) {
            return Map.of();
        }
        if (variables instanceof Map) {
            LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
            Map variablesMap = (Map)variables;
            variablesMap.forEach((k, v) -> result.put(String.valueOf(k), v));
            return result;
        }
        return this.toVariableMap(String.valueOf(variables));
    }

    private Map<String, Object> toVariableMap(String jsonString) {
        if (jsonString == null || jsonString.trim().isBlank()) {
            return Map.of();
        }
        return (Map)JSONB.fromJson(jsonString, LinkedHashMap.class);
    }

    public static class Builder
    implements io.helidon.common.Builder<Builder, GraphQlService> {
        private String context = "/graphql";
        private String schemaUri = "/schema.graphql";
        private CrossOriginConfig crossOriginConfig;
        private Supplier<? extends ExecutorService> executor;
        private InvocationHandler handler;

        private Builder() {
        }

        public GraphQlService build() {
            if (this.handler == null) {
                throw new IllegalStateException("Invocation handler must be defined");
            }
            if (this.executor == null) {
                this.executor = ((ThreadPoolConfig.Builder)((ThreadPoolConfig.Builder)ServerThreadPoolSupplier.builder().name("graphql")).threadNamePrefix("graphql-")).build();
            }
            return new GraphQlService(this);
        }

        public Builder config(Config config) {
            config.get("web-context").asString().ifPresent(this::webContext);
            config.get("schema-uri").asString().ifPresent(this::schemaUri);
            config.get("cors").as(CrossOriginConfig::create).ifPresent(this::crossOriginConfig);
            if (this.executor == null) {
                this.executor = ((ThreadPoolConfig.Builder)((ThreadPoolConfig.Builder)((ThreadPoolConfig.Builder)ServerThreadPoolSupplier.builder().name("graphql")).threadNamePrefix("graphql-")).config((io.helidon.common.config.Config)config.get("executor-service"))).build();
            }
            return this;
        }

        public Builder invocationHandler(InvocationHandler handler) {
            this.handler = handler;
            return this;
        }

        public Builder invocationHandler(Supplier<InvocationHandler> handler) {
            return this.invocationHandler(handler.get());
        }

        public Builder webContext(String path) {
            this.context = path.startsWith("/") ? path : "/" + path;
            return this;
        }

        public Builder schemaUri(String uri) {
            this.schemaUri = uri.startsWith("/") ? uri : "/" + uri;
            return this;
        }

        public Builder crossOriginConfig(CrossOriginConfig crossOriginConfig) {
            Objects.requireNonNull(crossOriginConfig, "CrossOriginConfig must be non-null");
            this.crossOriginConfig = crossOriginConfig;
            return this;
        }

        public Builder executor(ExecutorService executor) {
            this.executor = () -> executor;
            return this;
        }

        public Builder executor(Supplier<? extends ExecutorService> executor) {
            this.executor = executor;
            return this;
        }
    }
}

