/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver.cors;

import io.helidon.common.http.Http;
import io.helidon.webserver.ServerResponse;
import io.helidon.webserver.cors.CorsSupportBase;

class ResponseAdapterSe
implements CorsSupportBase.ResponseAdapter<ServerResponse> {
    private final ServerResponse serverResponse;

    ResponseAdapterSe(ServerResponse serverResponse) {
        this.serverResponse = serverResponse;
    }

    @Override
    public CorsSupportBase.ResponseAdapter<ServerResponse> header(String key, String value) {
        this.serverResponse.headers().add(key, new String[]{value});
        return this;
    }

    @Override
    public CorsSupportBase.ResponseAdapter<ServerResponse> header(String key, Object value) {
        this.serverResponse.headers().add(key, new String[]{value.toString()});
        return this;
    }

    @Override
    public ServerResponse forbidden(String message) {
        this.serverResponse.status(Http.ResponseStatus.create((int)Http.Status.FORBIDDEN_403.code(), (String)message));
        return this.serverResponse;
    }

    @Override
    public ServerResponse ok() {
        this.serverResponse.status(Http.Status.OK_200.code());
        return this.serverResponse;
    }

    @Override
    public int status() {
        return this.serverResponse.status().code();
    }
}

