/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver.cors;

import io.helidon.config.Config;
import io.helidon.config.ConfigValue;
import io.helidon.webserver.cors.CorsSupportHelper;
import io.helidon.webserver.cors.CrossOriginConfig;
import io.helidon.webserver.cors.MappedCrossOriginConfig;

class Loader {
    Loader() {
    }

    static class Mapped {
        Mapped() {
        }

        static MappedCrossOriginConfig.Builder applyConfig(Config config) {
            return Mapped.applyConfig(MappedCrossOriginConfig.builder(), config);
        }

        static MappedCrossOriginConfig.Builder applyConfig(MappedCrossOriginConfig.Builder builder, Config config) {
            Config item;
            config.get("enabled").asBoolean().ifPresent(builder::enabled);
            Config pathsNode = config.get("paths");
            CrossOriginConfig.Builder allPathsBuilder = null;
            int i = 0;
            while ((item = pathsNode.get(Integer.toString(i++))).exists()) {
                ConfigValue basicConfigValue = item.as(CrossOriginConfig::builder);
                if (!basicConfigValue.isPresent()) continue;
                CrossOriginConfig.Builder basicBuilder = (CrossOriginConfig.Builder)basicConfigValue.get();
                if (basicBuilder.pathPattern().equals("{+}")) {
                    allPathsBuilder = basicBuilder;
                    continue;
                }
                builder.put(basicBuilder.pathPattern(), basicBuilder);
            }
            if (allPathsBuilder != null) {
                builder.put(allPathsBuilder.pathPattern(), allPathsBuilder);
            }
            return builder;
        }
    }

    static class Basic {
        Basic() {
        }

        static CrossOriginConfig.Builder applyConfig(CrossOriginConfig.Builder builder, Config config) {
            config.get("enabled").asBoolean().ifPresent(builder::enabled);
            config.get("path-pattern").asString().ifPresent(builder::pathPattern);
            config.get("allow-origins").asList(String.class).ifPresent(s -> builder.allowOrigins(CorsSupportHelper.parseHeader(s).toArray(new String[0])));
            config.get("allow-methods").asList(String.class).ifPresent(s -> builder.allowMethods(CorsSupportHelper.parseHeader(s).toArray(new String[0])));
            config.get("allow-headers").asList(String.class).ifPresent(s -> builder.allowHeaders(CorsSupportHelper.parseHeader(s).toArray(new String[0])));
            config.get("expose-headers").asList(String.class).ifPresent(s -> builder.exposeHeaders(CorsSupportHelper.parseHeader(s).toArray(new String[0])));
            config.get("allow-credentials").as(Boolean.class).ifPresent(builder::allowCredentials);
            config.get("max-age").as(Long.class).ifPresent(builder::maxAgeSeconds);
            return builder;
        }
    }
}

