/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver.cors;

import io.helidon.config.Config;
import io.helidon.webserver.cors.CrossOriginConfig;
import io.helidon.webserver.cors.Loader;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;

public class MappedCrossOriginConfig
implements Iterable<Map.Entry<String, CrossOriginConfig>> {
    private String name = "";
    private boolean isEnabled = true;
    private final Map<String, Buildable> buildables;

    private MappedCrossOriginConfig(Builder builder) {
        this.name = builder.nameOpt.orElse("");
        this.isEnabled = builder.enabledOpt.orElse(true);
        this.buildables = builder.builders;
        this.buildables.forEach((? super K path, ? super V b) -> b.get());
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(Config config) {
        return MappedCrossOriginConfig.builder().config(config);
    }

    public static MappedCrossOriginConfig create(Config config) {
        return MappedCrossOriginConfig.builder(config).build();
    }

    @Override
    public Iterator<Map.Entry<String, CrossOriginConfig>> iterator() {
        return new Iterator<Map.Entry<String, CrossOriginConfig>>(){
            private final Iterator<Map.Entry<String, Buildable>> it;
            {
                this.it = MappedCrossOriginConfig.this.buildables.entrySet().iterator();
            }

            @Override
            public boolean hasNext() {
                return this.it.hasNext();
            }

            @Override
            public Map.Entry<String, CrossOriginConfig> next() {
                Map.Entry<String, Buildable> next = this.it.next();
                return new AbstractMap.SimpleEntry<String, CrossOriginConfig>(next.getKey(), next.getValue().get());
            }
        };
    }

    public void forEach(BiConsumer<String, CrossOriginConfig> consumer) {
        this.buildables.forEach((? super K path, ? super V buildable) -> consumer.accept((String)path, buildable.get()));
    }

    public CrossOriginConfig get(String pathPattern) {
        Buildable b = this.buildables.get(pathPattern);
        return b == null ? null : b.get();
    }

    public String name() {
        return this.name;
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public String toString() {
        return String.format("MappedCrossOriginConfig{name='%s', isEnabled=%b, buildables=%s}", this.name, this.isEnabled, this.buildables);
    }

    public static class Builder
    implements io.helidon.common.Builder<Builder, MappedCrossOriginConfig> {
        private Optional<String> nameOpt = Optional.empty();
        private Optional<Boolean> enabledOpt = Optional.empty();
        private final Map<String, Buildable> builders = new HashMap<String, Buildable>();

        private Builder() {
        }

        public MappedCrossOriginConfig build() {
            return new MappedCrossOriginConfig(this);
        }

        public Builder name(String name) {
            this.nameOpt = Optional.of(name);
            return this;
        }

        public Builder enabled(boolean enabled) {
            this.enabledOpt = Optional.of(enabled);
            return this;
        }

        public Builder put(String path, CrossOriginConfig.Builder builder) {
            this.builders.put(path, new Buildable(builder));
            return this;
        }

        public Builder config(Config corsConfig) {
            return Loader.Mapped.applyConfig(corsConfig);
        }
    }

    private static class Buildable {
        private final CrossOriginConfig.Builder builder;
        private CrossOriginConfig crossOriginConfig;

        Buildable(CrossOriginConfig.Builder builder) {
            this.builder = builder;
        }

        CrossOriginConfig get() {
            if (this.crossOriginConfig == null) {
                this.crossOriginConfig = this.builder.build();
            }
            return this.crossOriginConfig;
        }

        public String toString() {
            return String.format("Buildable{%s}", this.crossOriginConfig == null ? this.builder.toString() : this.crossOriginConfig.toString());
        }
    }
}

