/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver.cors;

import io.helidon.config.Config;
import io.helidon.webserver.cors.Aggregator;
import io.helidon.webserver.cors.CorsSetter;
import io.helidon.webserver.cors.CorsSupportHelper;
import io.helidon.webserver.cors.CrossOriginConfig;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class CorsSupportBase<Q, R, T extends CorsSupportBase<Q, R, T, B>, B extends Builder<Q, R, T, B>> {
    private static final Logger LOGGER = Logger.getLogger(CorsSupportBase.class.getName());
    private final String name;
    private final CorsSupportHelper<Q, R> helper;

    protected CorsSupportBase(Builder<Q, R, T, B> builder) {
        this.name = builder.name;
        builder.helperBuilder.name(builder.name);
        if (builder.requestDefaultBehaviorIfNone) {
            builder.helperBuilder.requestDefaultBehaviorIfNone();
        }
        this.helper = builder.helperBuilder.build();
    }

    protected Optional<R> processRequest(RequestAdapter<Q> requestAdapter, ResponseAdapter<R> responseAdapter) {
        return this.helper.processRequest(requestAdapter, responseAdapter);
    }

    protected void prepareResponse(RequestAdapter<Q> requestAdapter, ResponseAdapter<R> responseAdapter) {
        this.helper.prepareResponse(requestAdapter, responseAdapter);
    }

    protected CorsSupportHelper<Q, R> helper() {
        return this.helper;
    }

    protected String describe() {
        return this.helper.toString();
    }

    protected String name() {
        return this.name;
    }

    protected static interface ResponseAdapter<T> {
        public ResponseAdapter<T> header(String var1, String var2);

        public ResponseAdapter<T> header(String var1, Object var2);

        public T forbidden(String var1);

        public T ok();

        public int status();
    }

    protected static interface RequestAdapter<T> {
        public String path();

        public Optional<String> firstHeader(String var1);

        public boolean headerContainsKey(String var1);

        public List<String> allHeaders(String var1);

        public String method();

        public void next();

        public T request();
    }

    public static abstract class Builder<Q, R, T extends CorsSupportBase<Q, R, T, B>, B extends Builder<Q, R, T, B>>
    implements io.helidon.common.Builder<CorsSupportBase<Q, R, T, B>>,
    CorsSetter<Builder<Q, R, T, B>> {
        private String name = "";
        private final CorsSupportHelper.Builder<Q, R> helperBuilder = CorsSupportHelper.builder();
        private final Aggregator.Builder aggregatorBuilder = this.helperBuilder.aggregatorBuilder();
        private boolean requestDefaultBehaviorIfNone = false;

        protected Builder() {
        }

        protected abstract B me();

        public abstract T build();

        public B config(Config config) {
            this.reportUseOfMissingConfig(config);
            this.helperBuilder.config(config);
            return this.me();
        }

        public B mappedConfig(Config config) {
            this.reportUseOfMissingConfig(config);
            this.helperBuilder.mappedConfig(config);
            return this.me();
        }

        @Override
        public B enabled(boolean value) {
            this.aggregatorBuilder.enabled(value);
            return this.me();
        }

        public B addCrossOrigin(String path, CrossOriginConfig crossOrigin) {
            this.aggregatorBuilder.addCrossOrigin(path, crossOrigin);
            return this.me();
        }

        public B addCrossOrigin(CrossOriginConfig crossOrigin) {
            this.aggregatorBuilder.addPathlessCrossOrigin(crossOrigin);
            return this.me();
        }

        public B name(String name) {
            Objects.requireNonNull(name, "CorsSupport name is optional but cannot be null");
            this.name = name;
            this.helperBuilder.name(name);
            return this.me();
        }

        @Override
        public B allowOrigins(String ... origins) {
            this.aggregatorBuilder.allowOrigins(origins);
            return this.me();
        }

        @Override
        public B allowHeaders(String ... allowHeaders) {
            this.aggregatorBuilder.allowHeaders(allowHeaders);
            return this.me();
        }

        @Override
        public B exposeHeaders(String ... exposeHeaders) {
            this.aggregatorBuilder.exposeHeaders(exposeHeaders);
            return this.me();
        }

        @Override
        public B allowMethods(String ... allowMethods) {
            this.aggregatorBuilder.allowMethods(allowMethods);
            return this.me();
        }

        @Override
        public B allowCredentials(boolean allowCredentials) {
            this.aggregatorBuilder.allowCredentials(allowCredentials);
            return this.me();
        }

        @Override
        public B maxAgeSeconds(long maxAgeSeconds) {
            this.aggregatorBuilder.maxAgeSeconds(maxAgeSeconds);
            return this.me();
        }

        protected Builder<Q, R, T, B> secondaryLookupSupplier(Supplier<Optional<CrossOriginConfig>> secondaryLookupSupplier) {
            this.helperBuilder.secondaryLookupSupplier(secondaryLookupSupplier);
            return this;
        }

        protected Builder requestDefaultBehaviorIfNone() {
            this.requestDefaultBehaviorIfNone = true;
            return this;
        }

        private void reportUseOfMissingConfig(Config config) {
            if (!config.exists()) {
                LOGGER.log(Level.INFO, String.format("Attempt to load %s using empty config with key '%s'; continuing with default CORS information", this.getClass().getSuperclass().getSimpleName(), config.key().toString()));
            }
        }
    }
}

