/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver.cors;

import io.helidon.common.http.Http;
import io.helidon.webserver.cors.CorsSupportBase;
import io.helidon.webserver.cors.CorsSupportHelper;
import io.helidon.webserver.cors.CrossOriginConfig;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;

class LogHelper {
    static final Level DECISION_LEVEL = Level.FINE;
    static final Level DETAILED_DECISION_LEVEL = Level.FINER;

    private LogHelper() {
    }

    static <T> void logIsRequestTypeNormal(boolean result, boolean silent, CorsSupportBase.RequestAdapter<T> requestAdapter, Optional<String> originOpt, Optional<String> hostOpt) {
        if (silent || !CorsSupportHelper.LOGGER.isLoggable(DECISION_LEVEL)) {
            return;
        }
        ArrayList<String> reasonsWhyNormal = new ArrayList<String>();
        ArrayList<String> factorsWhyCrossHost = new ArrayList<String>();
        if (originOpt.isEmpty()) {
            reasonsWhyNormal.add("header Origin is absent");
        } else {
            factorsWhyCrossHost.add(String.format("header %s is present (%s)", "Origin", originOpt.get()));
        }
        if (hostOpt.isEmpty()) {
            reasonsWhyNormal.add("header Host is absent");
        } else {
            factorsWhyCrossHost.add(String.format("header %s is present (%s)", "Host", hostOpt.get()));
        }
        if (hostOpt.isPresent() && originOpt.isPresent()) {
            String partOfOriginMatchingHost = "://" + hostOpt.get();
            if (originOpt.get().contains(partOfOriginMatchingHost)) {
                reasonsWhyNormal.add(String.format("header %s '%s' matches header %s '%s'", "Origin", originOpt.get(), "Host", hostOpt.get()));
            } else {
                factorsWhyCrossHost.add(String.format("header %s '%s' does not match header %s '%s'", "Origin", originOpt.get(), "Host", hostOpt.get()));
            }
        }
        if (result) {
            CorsSupportHelper.LOGGER.log(DECISION_LEVEL, () -> String.format("Request %s is not cross-host: %s", requestAdapter, reasonsWhyNormal));
        } else {
            CorsSupportHelper.LOGGER.log(DECISION_LEVEL, () -> String.format("Request %s is cross-host: %s", requestAdapter, factorsWhyCrossHost));
        }
    }

    static <T> void logInferRequestType(CorsSupportHelper.RequestType result, boolean silent, CorsSupportBase.RequestAdapter<T> requestAdapter, String methodName, boolean requestContainsAccessControlRequestMethodHeader) {
        if (silent || !CorsSupportHelper.LOGGER.isLoggable(DECISION_LEVEL)) {
            return;
        }
        ArrayList<String> reasonsWhyCORS = new ArrayList<String>();
        ArrayList<String> factorsWhyPreflight = new ArrayList<String>();
        if (!methodName.equalsIgnoreCase(Http.Method.OPTIONS.name())) {
            reasonsWhyCORS.add(String.format("method is %s, not %s", methodName, Http.Method.OPTIONS.name()));
        } else {
            factorsWhyPreflight.add(String.format("method is %s", methodName));
        }
        if (!requestContainsAccessControlRequestMethodHeader) {
            reasonsWhyCORS.add(String.format("header %s is absent", "Access-Control-Request-Method"));
        } else {
            factorsWhyPreflight.add(String.format("header %s is present(%s)", "Access-Control-Request-Method", requestAdapter.firstHeader("Access-Control-Request-Method")));
        }
        CorsSupportHelper.LOGGER.log(DECISION_LEVEL, String.format("Request %s is of type %s; %s", requestAdapter, result.name(), result == CorsSupportHelper.RequestType.PREFLIGHT ? factorsWhyPreflight : reasonsWhyCORS));
    }

    static class MatcherChecks<T> {
        private final Map<CrossOriginConfig, MatcherCheck> checks;
        private final Logger logger;
        private final boolean isLoggable;
        private final Function<T, CrossOriginConfig> getter;

        MatcherChecks(Logger logger, Function<T, CrossOriginConfig> getter) {
            this.logger = logger;
            this.isLoggable = logger.isLoggable(DETAILED_DECISION_LEVEL);
            this.getter = getter;
            this.checks = this.isLoggable ? new LinkedHashMap() : null;
        }

        void put(T matcher) {
            if (this.isLoggable) {
                this.checks.put(this.getter.apply(matcher), new MatcherCheck());
            }
        }

        void matched(T matcher) {
            if (this.isLoggable) {
                this.checks.get(this.getter.apply(matcher)).matched(true);
            }
        }

        void enabled(CrossOriginConfig crossOriginConfig) {
            if (this.isLoggable) {
                this.checks.get(crossOriginConfig).enabled(true);
            }
        }

        void log() {
            if (!this.isLoggable) {
                return;
            }
            ArrayList results = new ArrayList();
            this.checks.forEach((k, v) -> results.add(v.toString((CrossOriginConfig)k)));
            this.logger.log(DETAILED_DECISION_LEVEL, results.stream().collect(Collectors.joining(System.lineSeparator(), "Matching results: [", "]")));
        }

        private static class MatcherCheck {
            private boolean matched;
            private boolean enabled;

            private MatcherCheck() {
            }

            void matched(boolean value) {
                this.matched = value;
            }

            void enabled(boolean value) {
                this.enabled = value;
            }

            public String toString(CrossOriginConfig crossOriginConfig) {
                return new StringJoiner(", ", MatcherCheck.class.getSimpleName() + "{", "}").add("crossOriginConfig=" + crossOriginConfig).add("matched=" + this.matched).add("enabled=" + this.enabled).toString();
            }
        }
    }

    static class Headers {
        private final List<Map.Entry<String, Object>> headers = new ArrayList<Map.Entry<String, Object>>();
        private final List<String> notes = CorsSupportHelper.LOGGER.isLoggable(DECISION_LEVEL) ? new ArrayList() : null;

        Headers() {
        }

        Headers add(String key, Object value) {
            this.headers.add(new AbstractMap.SimpleEntry<String, Object>(key, value));
            return this;
        }

        Headers add(String key, Object value, String note) {
            this.add(key, value);
            if (this.notes != null) {
                this.notes.add(note);
            }
            return this;
        }

        void setAndLog(BiConsumer<String, Object> consumer, String note) {
            this.headers.forEach(entry -> consumer.accept((String)entry.getKey(), entry.getValue()));
            CorsSupportHelper.LOGGER.log(DECISION_LEVEL, () -> note + ": " + this.headers + (this.notes == null ? "" : this.notes));
        }
    }
}

