/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver.cors;

import io.helidon.config.Config;
import io.helidon.webserver.Handler;
import io.helidon.webserver.Routing;
import io.helidon.webserver.ServerRequest;
import io.helidon.webserver.ServerResponse;
import io.helidon.webserver.Service;
import io.helidon.webserver.cors.CorsSupportBase;
import io.helidon.webserver.cors.RequestAdapterSe;
import io.helidon.webserver.cors.ResponseAdapterSe;
import java.util.Optional;

public class CorsSupport
extends CorsSupportBase<ServerRequest, ServerResponse, CorsSupport, Builder>
implements Service,
Handler {
    private CorsSupport(Builder builder) {
        super(builder);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static CorsSupport create() {
        return CorsSupport.builder().build();
    }

    public void update(Routing.Rules rules) {
        if (this.helper().isActive()) {
            rules.any(new Handler[]{this});
        }
    }

    public void accept(ServerRequest request, ServerResponse response) {
        if (!this.helper().isActive()) {
            request.next();
            return;
        }
        RequestAdapterSe requestAdapter = new RequestAdapterSe(request);
        ResponseAdapterSe responseAdapter = new ResponseAdapterSe(response);
        Optional<ServerResponse> responseOpt = this.helper().processRequest(requestAdapter, responseAdapter);
        responseOpt.ifPresentOrElse(ServerResponse::send, () -> this.prepareCORSResponseAndContinue(requestAdapter, responseAdapter));
    }

    private void prepareCORSResponseAndContinue(CorsSupportBase.RequestAdapter<ServerRequest> requestAdapter, CorsSupportBase.ResponseAdapter<ServerResponse> responseAdapter) {
        this.helper().prepareResponse(requestAdapter, responseAdapter);
        requestAdapter.next();
    }

    public static CorsSupport create(Config config) {
        return ((Builder)CorsSupport.builder().config(config)).build();
    }

    public static CorsSupport createMapped(Config config) {
        return ((Builder)CorsSupport.builder().mappedConfig(config)).build();
    }

    public String toString() {
        return String.format("CorsSupport[%s]{%s}", this.name(), this.describe());
    }

    public static class Builder
    extends CorsSupportBase.Builder<ServerRequest, ServerResponse, CorsSupport, Builder> {
        private static int builderCount = 0;

        Builder() {
            this.name("SE " + builderCount++);
            this.requestDefaultBehaviorIfNone();
        }

        @Override
        public CorsSupport build() {
            return new CorsSupport(this);
        }

        @Override
        protected Builder me() {
            return this;
        }
    }
}

