/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver.cors;

import io.helidon.config.Config;
import io.helidon.config.ConfigValue;
import io.helidon.webserver.PathMatcher;
import io.helidon.webserver.cors.CorsSetter;
import io.helidon.webserver.cors.CrossOriginConfig;
import io.helidon.webserver.cors.LogHelper;
import io.helidon.webserver.cors.MappedCrossOriginConfig;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import java.util.logging.Logger;

class Aggregator {
    static final String PATHLESS_KEY = "{+}";
    private static final Logger LOGGER = Logger.getLogger(Aggregator.class.getName());
    private final List<CrossOriginConfigMatchable> crossOriginConfigMatchables = new ArrayList<CrossOriginConfigMatchable>();
    private boolean isEnabled = true;

    static Aggregator create() {
        return Aggregator.builder().build();
    }

    static Builder builder() {
        return new Builder();
    }

    private Aggregator(Builder builder) {
        this.isEnabled = builder.isEnabled;
        this.crossOriginConfigMatchables.addAll(builder.crossOriginConfigMatchables);
    }

    public boolean isActive() {
        return this.isEnabled && !this.crossOriginConfigMatchables.isEmpty();
    }

    Optional<CrossOriginConfig> lookupCrossOrigin(String path, String method, Supplier<Optional<CrossOriginConfig>> secondaryLookup) {
        Optional<CrossOriginConfig> result = Aggregator.findFirst(this.crossOriginConfigMatchables, path, method).or(secondaryLookup);
        return result;
    }

    private static Optional<CrossOriginConfig> findFirst(List<CrossOriginConfigMatchable> matchables, String normalizedPath, String method) {
        LogHelper.MatcherChecks<CrossOriginConfigMatchable> checks = new LogHelper.MatcherChecks<CrossOriginConfigMatchable>(LOGGER, CrossOriginConfigMatchable::get);
        Optional<CrossOriginConfig> result = matchables.stream().peek(checks::put).filter(matchable -> matchable.matches(normalizedPath, method)).peek(checks::matched).map(CrossOriginConfigMatchable::get).filter(CrossOriginConfig::isEnabled).peek(checks::enabled).findFirst();
        checks.log();
        return result;
    }

    public String toString() {
        return "Aggregator{crossOriginConfigMatchables=" + this.crossOriginConfigMatchables + ", isActive=" + this.isActive() + "}";
    }

    private static class BuildableCrossOriginConfigMatchable
    extends CrossOriginConfigMatchable {
        private final CrossOriginConfig.Builder builder;
        private CrossOriginConfig config = null;

        BuildableCrossOriginConfigMatchable(String pathPattern, CrossOriginConfig.Builder builder) {
            super(pathPattern);
            this.builder = builder;
        }

        @Override
        CrossOriginConfig get() {
            if (this.config == null) {
                this.config = this.builder.build();
            }
            return this.config;
        }

        public String toString() {
            return String.format("BuildableCrossOriginConfigMatchable{matcher=%s, builder=%s, config=%s}", this.matcher(), this.builder, this.config);
        }
    }

    private static class FixedCrossOriginConfigMatchable
    extends CrossOriginConfigMatchable {
        private final CrossOriginConfig crossOriginConfig;

        FixedCrossOriginConfigMatchable(String pathPattern, CrossOriginConfig crossOriginConfig) {
            super(pathPattern);
            this.crossOriginConfig = crossOriginConfig;
        }

        @Override
        CrossOriginConfig get() {
            return this.crossOriginConfig;
        }

        public String toString() {
            return String.format("FixedCrossOriginConfigMatchable{matcher=%s, crossOriginConfig=%s}", this.matcher(), this.crossOriginConfig);
        }
    }

    private static abstract class CrossOriginConfigMatchable {
        private final PathMatcher matcher;

        CrossOriginConfigMatchable(String pathPattern) {
            this.matcher = PathMatcher.create((String)pathPattern);
        }

        boolean matches(String path, String method) {
            return this.matcher.match((CharSequence)path).matches() && this.get().matches(method);
        }

        PathMatcher matcher() {
            return this.matcher;
        }

        abstract CrossOriginConfig get();
    }

    static class Builder
    implements io.helidon.common.Builder<Aggregator>,
    CorsSetter<Builder> {
        private final List<CrossOriginConfigMatchable> crossOriginConfigMatchables = new ArrayList<CrossOriginConfigMatchable>();
        private boolean isEnabled = true;
        private boolean requestDefaultBehaviorIfNone = false;
        private BuildableCrossOriginConfigMatchable pathlessCrossOriginConfigMatchable;

        Builder() {
        }

        public Aggregator build() {
            if (this.pathlessCrossOriginConfigMatchable != null) {
                this.addPathlessCrossOrigin(this.pathlessCrossOriginConfigMatchable.get());
            }
            if (this.requestDefaultBehaviorIfNone && this.crossOriginConfigMatchables.isEmpty()) {
                this.addPathlessCrossOrigin(CrossOriginConfig.builder().build());
            }
            return new Aggregator(this);
        }

        Builder config(Config config) {
            ConfigValue configValue;
            if (config.exists() && (configValue = config.as(CrossOriginConfig::builder)).isPresent()) {
                CrossOriginConfig crossOriginConfig = ((CrossOriginConfig.Builder)configValue.get()).build();
                this.addPathlessCrossOrigin(crossOriginConfig);
            }
            return this;
        }

        Builder mappedConfig(Config config) {
            ConfigValue mappedConfigValue;
            if (config.exists() && (mappedConfigValue = config.as(MappedCrossOriginConfig::builder)).isPresent()) {
                MappedCrossOriginConfig mapped = ((MappedCrossOriginConfig.Builder)mappedConfigValue.get()).build();
                AtomicBoolean foundCrossOrigin = new AtomicBoolean();
                mapped.forEach((k, v) -> {
                    this.addCrossOrigin((String)k, (CrossOriginConfig)v);
                    foundCrossOrigin.set(true);
                });
                this.isEnabled = mapped.isEnabled();
                if (!foundCrossOrigin.get()) {
                    this.addPathlessCrossOrigin(CrossOriginConfig.builder().build());
                }
            }
            return this;
        }

        Builder addCrossOrigin(String pathPattern, CrossOriginConfig crossOrigin) {
            this.crossOriginConfigMatchables.add(new FixedCrossOriginConfigMatchable(pathPattern, crossOrigin));
            return this;
        }

        Builder requestDefaultBehaviorIfNone() {
            this.requestDefaultBehaviorIfNone = true;
            return this;
        }

        Builder addPathlessCrossOrigin(CrossOriginConfig crossOrigin) {
            this.crossOriginConfigMatchables.add(new FixedCrossOriginConfigMatchable(Aggregator.PATHLESS_KEY, crossOrigin));
            return this;
        }

        @Override
        public Builder enabled(boolean value) {
            this.isEnabled = value;
            return this;
        }

        @Override
        public Builder allowOrigins(String ... origins) {
            this.pathlessCrossOriginConfigBuilder().allowOrigins(origins);
            return this;
        }

        @Override
        public Builder allowHeaders(String ... allowHeaders) {
            this.pathlessCrossOriginConfigBuilder().allowHeaders(allowHeaders);
            return this;
        }

        @Override
        public Builder exposeHeaders(String ... exposeHeaders) {
            this.pathlessCrossOriginConfigBuilder().exposeHeaders(exposeHeaders);
            return this;
        }

        @Override
        public Builder allowMethods(String ... allowMethods) {
            this.pathlessCrossOriginConfigBuilder().allowMethods(allowMethods);
            return this;
        }

        @Override
        public Builder allowCredentials(boolean allowCredentials) {
            this.pathlessCrossOriginConfigBuilder().allowCredentials(allowCredentials);
            return this;
        }

        @Override
        public Builder maxAgeSeconds(long maxAgeSeconds) {
            this.pathlessCrossOriginConfigBuilder().maxAgeSeconds(maxAgeSeconds);
            return this;
        }

        private CrossOriginConfig.Builder pathlessCrossOriginConfigBuilder() {
            if (this.pathlessCrossOriginConfigMatchable == null) {
                BuildableCrossOriginConfigMatchable newMatchable;
                this.pathlessCrossOriginConfigMatchable = newMatchable = new BuildableCrossOriginConfigMatchable(Aggregator.PATHLESS_KEY, CrossOriginConfig.builder());
                this.crossOriginConfigMatchables.add(this.pathlessCrossOriginConfigMatchable);
            }
            return this.pathlessCrossOriginConfigMatchable.builder;
        }
    }
}

