/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver.context;

import io.helidon.builder.api.RuntimeType;
import io.helidon.config.Config;
import io.helidon.webserver.context.ContextFeatureConfig;
import io.helidon.webserver.context.ContextRoutingFeature;
import io.helidon.webserver.spi.ServerFeature;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;

@RuntimeType.PrototypedBy(value=ContextFeatureConfig.class)
public class ContextFeature
implements ServerFeature,
RuntimeType.Api<ContextFeatureConfig> {
    public static final double WEIGHT = 1100.0;
    static final String CONTEXT_ID = "context";
    private final ContextFeatureConfig config;

    ContextFeature(ContextFeatureConfig config) {
        this.config = config;
    }

    public static ContextFeatureConfig.Builder builder() {
        return ContextFeatureConfig.builder();
    }

    public static ContextFeature create(ContextFeatureConfig config) {
        return new ContextFeature(config);
    }

    public static ContextFeature create(Consumer<ContextFeatureConfig.Builder> builderConsumer) {
        return ((ContextFeatureConfig.Builder)ContextFeature.builder().update(builderConsumer)).build();
    }

    public static ContextFeature create() {
        return ContextFeature.builder().build();
    }

    public static ContextFeature create(Config config) {
        return ((ContextFeatureConfig.Builder)ContextFeature.builder().config((io.helidon.common.config.Config)config)).build();
    }

    public void setup(ServerFeature.ServerFeatureContext featureContext) {
        double featureWeight = this.config.weight();
        Set<String> sockets = this.config.sockets();
        featureContext.socket("@default").httpRouting().addFeature((Supplier)((Object)new ContextRoutingFeature(featureWeight)));
        for (String socket : sockets) {
            featureContext.socket(socket).httpRouting().addFeature((Supplier)((Object)new ContextRoutingFeature(featureWeight)));
        }
    }

    public String name() {
        return this.config.name();
    }

    public String type() {
        return CONTEXT_ID;
    }

    public ContextFeatureConfig prototype() {
        return this.config;
    }
}

