/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver.context;

import io.helidon.common.Weighted;
import io.helidon.common.context.Context;
import io.helidon.common.context.Contexts;
import io.helidon.config.Config;
import io.helidon.webserver.http.FilterChain;
import io.helidon.webserver.http.HttpFeature;
import io.helidon.webserver.http.HttpRouting;
import io.helidon.webserver.http.RoutingRequest;
import io.helidon.webserver.http.RoutingResponse;

public class ContextFeature
implements HttpFeature,
Weighted {
    private static final double WEIGHT = 1100.0;
    private final double weight;

    private ContextFeature(double weight) {
        this.weight = weight;
    }

    public static ContextFeature create() {
        return new ContextFeature(1100.0);
    }

    public static ContextFeature create(Config config) {
        return new ContextFeature((Double)config.get("weight").asDouble().orElse((Object)1100.0));
    }

    public void setup(HttpRouting.Builder routing) {
        routing.addFilter(this::filter);
    }

    public double weight() {
        return this.weight;
    }

    private void filter(FilterChain chain, RoutingRequest req, RoutingResponse res) {
        Contexts.runInContext((Context)req.context(), () -> ((FilterChain)chain).proceed());
    }
}

