/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver.context.propagation;

import io.helidon.config.Config;
import io.helidon.config.metadata.Configured;
import io.helidon.webserver.Handler;
import io.helidon.webserver.ServerRequest;
import io.helidon.webserver.ServerResponse;
import io.helidon.webserver.context.propagation.PropagationRecord;
import java.util.LinkedList;
import java.util.List;

public class ContextPropagationFilter
implements Handler {
    private final List<PropagationRecord> propagations;

    private ContextPropagationFilter(Builder builder) {
        this.propagations = List.copyOf(builder.propagations);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static ContextPropagationFilter create(Config config) {
        return ContextPropagationFilter.builder().config(config).build();
    }

    public void accept(ServerRequest req, ServerResponse res) {
        for (PropagationRecord propagation : this.propagations) {
            propagation.apply(req);
        }
        req.next();
    }

    @Configured(prefix="server.context", root=true, description="Propagation of context data across network")
    public static class Builder
    implements io.helidon.common.Builder<ContextPropagationFilter> {
        private final List<PropagationRecord> propagations = new LinkedList<PropagationRecord>();

        public ContextPropagationFilter build() {
            return new ContextPropagationFilter(this);
        }

        public Builder config(Config config) {
            config.get("records").asList(Config.class).ifPresent(it -> it.forEach(recordConfig -> this.addRecord(PropagationRecord.builder().config((Config)recordConfig).build())));
            return this;
        }

        public Builder addRecord(PropagationRecord record) {
            this.propagations.add(record);
            return this;
        }
    }
}

