/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver.context.propagation;

import io.helidon.webserver.ServerRequest;
import io.helidon.webserver.context.propagation.PropagationRecord;
import java.util.List;
import java.util.Optional;

class ArrayRecord
implements PropagationRecord {
    private final String classifier;
    private final String headerName;
    private final Optional<String[]> defaultValue;

    ArrayRecord(String classifier, String headerName, String[] defaultValue) {
        this.classifier = classifier;
        this.headerName = headerName;
        this.defaultValue = Optional.ofNullable(defaultValue);
    }

    @Override
    public void apply(ServerRequest req) {
        List all = req.headers().all(this.headerName);
        if (all.isEmpty() && this.defaultValue.isPresent()) {
            req.context().register((Object)this.classifier, (Object)this.defaultValue.get());
            return;
        }
        if (!all.isEmpty()) {
            req.context().register((Object)this.classifier, (Object)all.toArray(new String[0]));
        }
    }

    public String toString() {
        return this.headerName + " -> " + this.classifier + " (String[])";
    }
}

