/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver.context.propagation;

import io.helidon.webserver.ServerRequest;
import io.helidon.webserver.context.propagation.PropagationRecord;
import java.util.Optional;

class StringRecord
implements PropagationRecord {
    private final String classifier;
    private final String headerName;
    private final Optional<String> defaultValue;

    StringRecord(String classifier, String headerName, String defaultValue) {
        this.classifier = classifier;
        this.headerName = headerName;
        this.defaultValue = Optional.ofNullable(defaultValue);
    }

    @Override
    public void apply(ServerRequest req) {
        req.headers().first(this.headerName).or(() -> this.defaultValue).ifPresent(it -> req.context().register((Object)this.classifier, it));
    }

    public String toString() {
        return this.headerName + " -> " + this.classifier + " (String)";
    }
}

