/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver.context.propagation;

import io.helidon.config.Config;
import io.helidon.config.metadata.Configured;
import io.helidon.webserver.ServerRequest;
import io.helidon.webserver.context.propagation.ArrayRecord;
import io.helidon.webserver.context.propagation.StringRecord;

public interface PropagationRecord {
    public static Builder builder() {
        return new Builder();
    }

    public void apply(ServerRequest var1);

    @Configured(description="Context propagation record mapping HTTP header to context classifier.")
    public static class Builder
    implements io.helidon.common.Builder<PropagationRecord> {
        private String classifier;
        private String headerName;
        private String[] defaultValue;
        private boolean isArray;

        private Builder() {
        }

        public PropagationRecord build() {
            if (this.defaultValue == null || this.defaultValue.length == 0) {
                this.defaultValue = null;
            }
            if (this.classifier == null) {
                this.classifier = this.headerName;
            } else if (this.headerName == null) {
                this.headerName = this.classifier;
            }
            if (this.headerName == null) {
                throw new IllegalArgumentException("Either header name or classifier must be configured");
            }
            if (this.isArray) {
                return new ArrayRecord(this.classifier, this.headerName, this.defaultValue);
            }
            return new StringRecord(this.classifier, this.headerName, this.defaultValue == null ? null : this.defaultValue[0]);
        }

        public Builder config(Config config) {
            config.get("classifier").asString().ifPresent(this::classifier);
            config.get("header").asString().ifPresent(this::header);
            config.get("array").asBoolean().ifPresent(this::array);
            if (this.isArray) {
                config.get("default-value").as(String[].class).ifPresent(this::defaultValue);
            } else {
                config.get("default-value").asString().ifPresent(xva$0 -> this.defaultValue((String)xva$0));
            }
            return this;
        }

        public Builder classifier(String classifier) {
            this.classifier = classifier;
            return this;
        }

        public Builder header(String headerName) {
            this.headerName = headerName;
            return this;
        }

        public Builder defaultValue(String ... defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        public Builder array(boolean isArray) {
            this.isArray = isArray;
            return this;
        }
    }
}

