/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver.accesslog;

import io.helidon.webserver.accesslog.AbstractLogEntry;
import io.helidon.webserver.accesslog.AccessLogContext;

public final class SizeLogEntry
extends AbstractLogEntry {
    private static final String SIZE_CONTEXT_CLASSIFIER = SizeLogEntry.class.getName() + ".size";

    private SizeLogEntry(Builder builder) {
        super(builder);
    }

    public static SizeLogEntry create() {
        return SizeLogEntry.builder().build();
    }

    public static Builder builder() {
        return new Builder().defaults();
    }

    @Override
    public String doApply(AccessLogContext context) {
        return String.valueOf(context.serverResponse().bytesWritten());
    }

    public static final class Builder
    extends AbstractLogEntry.Builder<SizeLogEntry, Builder> {
        private Builder() {
        }

        public SizeLogEntry build() {
            return new SizeLogEntry(this);
        }

        private Builder defaults() {
            return (Builder)super.sanitize(false);
        }
    }
}

