/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver.accesslog;

import io.helidon.builder.api.Prototype;
import io.helidon.common.Generated;
import io.helidon.common.config.Config;
import io.helidon.webserver.accesslog.AccessLogConfigBlueprint;
import io.helidon.webserver.accesslog.AccessLogConfigSupport;
import io.helidon.webserver.accesslog.AccessLogEntry;
import io.helidon.webserver.accesslog.AccessLogFeature;
import java.time.Clock;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;

@Generated(value="io.helidon.builder.codegen.BuilderCodegen", trigger="io.helidon.webserver.accesslog.AccessLogConfigBlueprint")
public interface AccessLogConfig
extends AccessLogConfigBlueprint,
Prototype.Api {
    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(AccessLogConfig instance) {
        return (Builder)AccessLogConfig.builder().from(instance);
    }

    public static AccessLogConfig create(Config config) {
        return ((Builder)AccessLogConfig.builder().config(config)).buildPrototype();
    }

    public static AccessLogConfig create() {
        return AccessLogConfig.builder().buildPrototype();
    }

    public static class Builder
    extends BuilderBase<Builder, AccessLogConfig>
    implements io.helidon.common.Builder<Builder, AccessLogFeature> {
        private Builder() {
        }

        public AccessLogConfig buildPrototype() {
            this.preBuildPrototype();
            this.validatePrototype();
            return new BuilderBase.AccessLogConfigImpl(this);
        }

        public AccessLogFeature build() {
            return AccessLogFeature.create(this.buildPrototype());
        }
    }

    public static abstract class BuilderBase<BUILDER extends BuilderBase<BUILDER, PROTOTYPE>, PROTOTYPE extends AccessLogConfig>
    implements Prototype.ConfiguredBuilder<BUILDER, PROTOTYPE> {
        private final List<AccessLogEntry> entries = new ArrayList<AccessLogEntry>();
        private final Set<String> sockets = new LinkedHashSet<String>();
        private boolean enabled = true;
        private Clock clock = Clock.systemDefaultZone();
        private Config config;
        private double weight = 1000.0;
        private String format;
        private String loggerName = "io.helidon.webserver.AccessLog";
        private String name = "access-log";

        protected BuilderBase() {
        }

        public BUILDER from(AccessLogConfig prototype) {
            this.addEntries(prototype.entries());
            this.clock(prototype.clock());
            this.loggerName(prototype.loggerName());
            this.weight(prototype.weight());
            this.addSockets(prototype.sockets());
            this.name(prototype.name());
            this.format(prototype.format());
            this.enabled(prototype.enabled());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER from(BuilderBase<?, ?> builder) {
            this.addEntries(builder.entries());
            this.clock(builder.clock());
            this.loggerName(builder.loggerName());
            this.weight(builder.weight());
            this.addSockets(builder.sockets());
            this.name(builder.name());
            builder.format().ifPresent(this::format);
            this.enabled(builder.enabled());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER defaultLogFormat() {
            AccessLogConfigSupport.CustomMethods.defaultLogFormat(this);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER commonLogFormat() {
            AccessLogConfigSupport.CustomMethods.commonLogFormat(this);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER config(Config config) {
            Objects.requireNonNull(config);
            this.config = config;
            config.get("logger-name").as(String.class).ifPresent(this::loggerName);
            config.get("weight").as(Double.class).ifPresent(this::weight);
            config.get("sockets").asList(String.class).map(Set::copyOf).ifPresent(this::sockets);
            config.get("format").as(String.class).ifPresent(this::format);
            config.get("enabled").as(Boolean.class).ifPresent(this::enabled);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER entries(List<? extends AccessLogEntry> entries) {
            Objects.requireNonNull(entries);
            this.entries.clear();
            this.entries.addAll(entries);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addEntries(List<? extends AccessLogEntry> entries) {
            Objects.requireNonNull(entries);
            this.entries.addAll(entries);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addEntry(AccessLogEntry entry) {
            Objects.requireNonNull(entry);
            this.entries.add(entry);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clock(Clock clock) {
            Objects.requireNonNull(clock);
            this.clock = clock;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER loggerName(String loggerName) {
            Objects.requireNonNull(loggerName);
            this.loggerName = loggerName;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER weight(double weight) {
            this.weight = weight;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER sockets(Set<? extends String> sockets) {
            Objects.requireNonNull(sockets);
            this.sockets.clear();
            this.sockets.addAll(sockets);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addSockets(Set<? extends String> sockets) {
            Objects.requireNonNull(sockets);
            this.sockets.addAll(sockets);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER name(String name) {
            Objects.requireNonNull(name);
            this.name = name;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearFormat() {
            this.format = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER format(String format) {
            Objects.requireNonNull(format);
            this.format = format;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER enabled(boolean enabled) {
            this.enabled = enabled;
            return (BUILDER)((BuilderBase)this.self());
        }

        public List<AccessLogEntry> entries() {
            return this.entries;
        }

        public Clock clock() {
            return this.clock;
        }

        public String loggerName() {
            return this.loggerName;
        }

        public double weight() {
            return this.weight;
        }

        public Set<String> sockets() {
            return this.sockets;
        }

        public String name() {
            return this.name;
        }

        public Optional<String> format() {
            return Optional.ofNullable(this.format);
        }

        public boolean enabled() {
            return this.enabled;
        }

        public Optional<Config> config() {
            return Optional.ofNullable(this.config);
        }

        public String toString() {
            return "AccessLogConfigBuilder{entries=" + String.valueOf(this.entries) + ",clock=" + String.valueOf(this.clock) + ",loggerName=" + this.loggerName + ",weight=" + this.weight + ",sockets=" + String.valueOf(this.sockets) + ",name=" + this.name + ",format=" + this.format + ",enabled=" + this.enabled + "}";
        }

        protected void preBuildPrototype() {
            new AccessLogConfigSupport.BuilderDecorator().decorate(this);
        }

        protected void validatePrototype() {
        }

        BUILDER format(Optional<String> format) {
            Objects.requireNonNull(format);
            this.format = format.map(String.class::cast).orElse(this.format);
            return (BUILDER)((BuilderBase)this.self());
        }

        protected static class AccessLogConfigImpl
        implements AccessLogConfig,
        Supplier<AccessLogFeature> {
            private final boolean enabled;
            private final Clock clock;
            private final double weight;
            private final List<AccessLogEntry> entries;
            private final Optional<String> format;
            private final Set<String> sockets;
            private final String loggerName;
            private final String name;

            protected AccessLogConfigImpl(BuilderBase<?, ?> builder) {
                this.entries = List.copyOf(builder.entries());
                this.clock = builder.clock();
                this.loggerName = builder.loggerName();
                this.weight = builder.weight();
                this.sockets = Collections.unmodifiableSet(new LinkedHashSet<String>(builder.sockets()));
                this.name = builder.name();
                this.format = builder.format();
                this.enabled = builder.enabled();
            }

            public AccessLogFeature build() {
                return AccessLogFeature.create(this);
            }

            @Override
            public AccessLogFeature get() {
                return this.build();
            }

            @Override
            public List<AccessLogEntry> entries() {
                return this.entries;
            }

            @Override
            public Clock clock() {
                return this.clock;
            }

            @Override
            public String loggerName() {
                return this.loggerName;
            }

            @Override
            public double weight() {
                return this.weight;
            }

            @Override
            public Set<String> sockets() {
                return this.sockets;
            }

            @Override
            public String name() {
                return this.name;
            }

            @Override
            public Optional<String> format() {
                return this.format;
            }

            @Override
            public boolean enabled() {
                return this.enabled;
            }

            public String toString() {
                return "AccessLogConfig{entries=" + String.valueOf(this.entries) + ",clock=" + String.valueOf(this.clock) + ",loggerName=" + this.loggerName + ",weight=" + this.weight + ",sockets=" + String.valueOf(this.sockets) + ",name=" + this.name + ",format=" + String.valueOf(this.format) + ",enabled=" + this.enabled + "}";
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof AccessLogConfig)) {
                    return false;
                }
                AccessLogConfig other = (AccessLogConfig)o;
                return Objects.equals(this.entries, other.entries()) && Objects.equals(this.clock, other.clock()) && Objects.equals(this.loggerName, other.loggerName()) && this.weight == other.weight() && Objects.equals(this.sockets, other.sockets()) && Objects.equals(this.name, other.name()) && Objects.equals(this.format, other.format()) && this.enabled == other.enabled();
            }

            public int hashCode() {
                return Objects.hash(this.entries, this.clock, this.loggerName, this.weight, this.sockets, this.name, this.format, this.enabled);
            }
        }
    }
}

