/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver.accesslog;

import io.helidon.webserver.accesslog.AbstractLogEntry;
import io.helidon.webserver.accesslog.AccessLogContext;
import java.time.format.DateTimeFormatter;

public final class TimestampLogEntry
extends AbstractLogEntry {
    private static final String DEFAULT_FORMAT = "'['dd/MMM/YYYY:HH:mm:ss ZZZ']'";
    private static final DateTimeFormatter DEFAULT_FORMATTER = DateTimeFormatter.ofPattern("'['dd/MMM/YYYY:HH:mm:ss ZZZ']'");
    private final DateTimeFormatter formatter;

    private TimestampLogEntry(Builder builder) {
        super(builder);
        this.formatter = builder.formatter;
    }

    public static TimestampLogEntry create() {
        return TimestampLogEntry.builder().build();
    }

    public static Builder builder() {
        return new Builder().defaults();
    }

    @Override
    public String doApply(AccessLogContext context) {
        return this.formatter.format(context.requestDateTime());
    }

    public static final class Builder
    extends AbstractLogEntry.Builder<TimestampLogEntry, Builder> {
        private DateTimeFormatter formatter = DEFAULT_FORMATTER;

        private Builder() {
        }

        public TimestampLogEntry build() {
            return new TimestampLogEntry(this);
        }

        public Builder formatter(DateTimeFormatter formatter) {
            this.formatter = formatter;
            return this;
        }

        private Builder defaults() {
            return (Builder)super.sanitize(false);
        }
    }
}

