/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver.accesslog;

import io.helidon.common.http.ContextualRegistry;
import io.helidon.common.http.DataChunk;
import io.helidon.common.reactive.Flow;
import io.helidon.webserver.ServerRequest;
import io.helidon.webserver.ServerResponse;
import io.helidon.webserver.accesslog.AbstractLogEntry;
import io.helidon.webserver.accesslog.AccessLogContext;
import java.util.concurrent.atomic.LongAdder;

public final class SizeLogEntry
extends AbstractLogEntry {
    private static final String SIZE_CONTEXT_CLASSIFIER = SizeLogEntry.class.getName() + ".size";

    private SizeLogEntry(Builder builder) {
        super(builder);
    }

    public static SizeLogEntry create() {
        return SizeLogEntry.builder().build();
    }

    public static Builder builder() {
        return new Builder().defaults();
    }

    @Override
    public void accept(ServerRequest req, ServerResponse res) {
        ContextualRegistry context = req.context();
        res.registerFilter(originalPublisher -> new ByteCountingPublisher((Flow.Publisher)originalPublisher, context));
    }

    @Override
    public String doApply(AccessLogContext context) {
        return context.serverRequest().context().get((Object)SIZE_CONTEXT_CLASSIFIER, Long.class).map(String::valueOf).orElse("-");
    }

    private static final class ByteCountingSubscriber
    implements Flow.Subscriber<DataChunk> {
        private final Flow.Subscriber<? super DataChunk> subscriber;
        private final ContextualRegistry context;
        private final LongAdder sizeAdder = new LongAdder();

        private ByteCountingSubscriber(Flow.Subscriber<? super DataChunk> subscriber, ContextualRegistry context) {
            this.subscriber = subscriber;
            this.context = context;
        }

        public void onSubscribe(Flow.Subscription subscription) {
            this.subscriber.onSubscribe(subscription);
        }

        public void onNext(DataChunk item) {
            this.sizeAdder.add(item.data().remaining());
            this.subscriber.onNext((Object)item);
        }

        public void onError(Throwable throwable) {
            this.sizeAdder.reset();
            this.sizeAdder.decrement();
            this.subscriber.onError(throwable);
        }

        public void onComplete() {
            long sum = this.sizeAdder.sum();
            if (sum != -1L) {
                this.context.register((Object)SIZE_CONTEXT_CLASSIFIER, (Object)this.sizeAdder.sum());
            }
            this.subscriber.onComplete();
        }
    }

    private static final class ByteCountingPublisher
    implements Flow.Publisher<DataChunk> {
        private final Flow.Publisher<DataChunk> originalPublisher;
        private final ContextualRegistry context;

        private ByteCountingPublisher(Flow.Publisher<DataChunk> originalPublisher, ContextualRegistry context) {
            this.originalPublisher = originalPublisher;
            this.context = context;
        }

        public void subscribe(Flow.Subscriber<? super DataChunk> subscriber) {
            this.originalPublisher.subscribe((Flow.Subscriber)new ByteCountingSubscriber(subscriber, this.context));
        }
    }

    public static final class Builder
    extends AbstractLogEntry.Builder<SizeLogEntry, Builder> {
        private Builder() {
        }

        public SizeLogEntry build() {
            return new SizeLogEntry(this);
        }

        private Builder defaults() {
            return (Builder)super.sanitize(false);
        }
    }
}

