/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver.accesslog;

import io.helidon.webserver.ServerRequest;
import io.helidon.webserver.accesslog.AbstractLogEntry;
import io.helidon.webserver.accesslog.AccessLogContext;

public final class RequestLineLogEntry
extends AbstractLogEntry {
    private RequestLineLogEntry(Builder builder) {
        super(builder);
    }

    public static RequestLineLogEntry create() {
        return RequestLineLogEntry.builder().build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public String doApply(AccessLogContext context) {
        ServerRequest request = context.serverRequest();
        return '\"' + request.method().name() + ' ' + request.path().toRawString() + ' ' + request.version().value() + '\"';
    }

    public static final class Builder
    extends AbstractLogEntry.Builder<RequestLineLogEntry, Builder> {
        private Builder() {
        }

        public RequestLineLogEntry build() {
            return new RequestLineLogEntry(this);
        }
    }
}

