/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver.accesslog;

import io.helidon.common.CollectionsHelper;
import io.helidon.config.Config;
import io.helidon.webserver.Handler;
import io.helidon.webserver.Routing;
import io.helidon.webserver.ServerRequest;
import io.helidon.webserver.ServerResponse;
import io.helidon.webserver.Service;
import io.helidon.webserver.accesslog.AccessLogContext;
import io.helidon.webserver.accesslog.AccessLogEntry;
import io.helidon.webserver.accesslog.HeaderLogEntry;
import io.helidon.webserver.accesslog.HostLogEntry;
import io.helidon.webserver.accesslog.RequestLineLogEntry;
import io.helidon.webserver.accesslog.SizeLogEntry;
import io.helidon.webserver.accesslog.StatusLogEntry;
import io.helidon.webserver.accesslog.TimeTakenLogEntry;
import io.helidon.webserver.accesslog.TimestampLogEntry;
import io.helidon.webserver.accesslog.UserIdLogEntry;
import io.helidon.webserver.accesslog.UserLogEntry;
import java.time.Clock;
import java.time.ZonedDateTime;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class AccessLogSupport
implements Service {
    public static final String DEFAULT_LOGGER_NAME = "io.helidon.webserver.AccessLog";
    private static final Pattern HEADER_ENTRY_PATTERN = Pattern.compile("%\\{(.*?)}i");
    private final List<AccessLogEntry> logFormat;
    private final Logger logger;
    private final boolean enabled;
    private final Clock clock;

    private AccessLogSupport(Builder builder) {
        this.enabled = builder.enabled;
        this.logFormat = builder.entries;
        this.clock = builder.clock;
        this.logger = Logger.getLogger(builder.loggerName);
    }

    public static AccessLogSupport create() {
        return AccessLogSupport.builder().build();
    }

    public static AccessLogSupport create(Config config) {
        return AccessLogSupport.builder().config(config).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public void update(Routing.Rules rules) {
        if (this.enabled) {
            rules.any(new Handler[]{this::handle});
        }
    }

    private void handle(ServerRequest req, ServerResponse res) {
        ZonedDateTime now = ZonedDateTime.now(this.clock);
        long nanoNow = System.nanoTime();
        this.logFormat.forEach(entry -> entry.accept(req, res));
        res.whenSent().thenAccept(aResponse -> this.log(req, (ServerResponse)aResponse, now, nanoNow)).exceptionally(throwable -> {
            this.log(req, res, now, nanoNow);
            return null;
        });
        req.next();
    }

    private void log(ServerRequest req, ServerResponse res, ZonedDateTime timeStart, long nanoStart) {
        this.logger.log(Level.INFO, this.createLogRecord(req, res, timeStart, nanoStart, ZonedDateTime.now(this.clock), System.nanoTime()));
    }

    String createLogRecord(final ServerRequest req, final ServerResponse res, final ZonedDateTime timeStart, final long nanoStart, final ZonedDateTime timeNow, final long nanoNow) {
        AccessLogContext ctx = new AccessLogContext(){

            @Override
            public long requestNanoTime() {
                return nanoStart;
            }

            @Override
            public long responseNanoTime() {
                return nanoNow;
            }

            @Override
            public ZonedDateTime requestDateTime() {
                return timeStart;
            }

            @Override
            public ZonedDateTime responseDateTime() {
                return timeNow;
            }

            @Override
            public ServerRequest serverRequest() {
                return req;
            }

            @Override
            public ServerResponse serverResponse() {
                return res;
            }
        };
        StringBuilder sb = new StringBuilder();
        for (AccessLogEntry entry : this.logFormat) {
            sb.append(entry.apply(ctx));
            sb.append(" ");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        return sb.toString();
    }

    public static final class Builder
    implements io.helidon.common.Builder<AccessLogSupport> {
        private static final List<AccessLogEntry> COMMON_FORMAT = CollectionsHelper.listOf((Object[])new AccessLogEntry[]{HostLogEntry.create(), UserIdLogEntry.create(), UserLogEntry.create(), TimestampLogEntry.create(), RequestLineLogEntry.create(), StatusLogEntry.create(), SizeLogEntry.create()});
        private static final List<AccessLogEntry> HELIDON_FORMAT = CollectionsHelper.listOf((Object[])new AccessLogEntry[]{HostLogEntry.create(), UserLogEntry.create(), TimestampLogEntry.create(), RequestLineLogEntry.create(), StatusLogEntry.create(), SizeLogEntry.create(), TimeTakenLogEntry.create()});
        private final List<AccessLogEntry> entries = new LinkedList<AccessLogEntry>();
        private Clock clock = Clock.systemDefaultZone();
        private String loggerName = "io.helidon.webserver.AccessLog";
        private boolean enabled = true;

        private Builder() {
        }

        public AccessLogSupport build() {
            if (this.entries.isEmpty()) {
                this.helidonLogFormat();
            }
            return new AccessLogSupport(this);
        }

        public Builder helidonLogFormat() {
            this.entries.clear();
            this.entries.addAll(HELIDON_FORMAT);
            return this;
        }

        public Builder commonLogFormat() {
            this.entries.clear();
            this.entries.addAll(COMMON_FORMAT);
            return this;
        }

        public Builder logFormatString(String format) {
            String[] formatEntries;
            this.entries.clear();
            String[] stringArray = formatEntries = format.split(" ");
            int n = stringArray.length;
            block22: for (int i = 0; i < n; ++i) {
                String formatEntry;
                switch (formatEntry = stringArray[i]) {
                    case "%h": {
                        this.add(HostLogEntry.create());
                        continue block22;
                    }
                    case "%l": {
                        this.add(UserIdLogEntry.create());
                        continue block22;
                    }
                    case "%u": {
                        this.add(UserLogEntry.create());
                        continue block22;
                    }
                    case "%t": {
                        this.add(TimestampLogEntry.create());
                        continue block22;
                    }
                    case "%r": {
                        this.add(RequestLineLogEntry.create());
                        continue block22;
                    }
                    case "%s": {
                        this.add(StatusLogEntry.create());
                        continue block22;
                    }
                    case "%b": {
                        this.add(SizeLogEntry.create());
                        continue block22;
                    }
                    case "%D": {
                        this.add(TimeTakenLogEntry.builder().unit(TimeUnit.MICROSECONDS).build());
                        continue block22;
                    }
                    case "%T": {
                        this.add(TimeTakenLogEntry.builder().unit(TimeUnit.SECONDS).build());
                        continue block22;
                    }
                    default: {
                        Matcher matcher = HEADER_ENTRY_PATTERN.matcher(formatEntry);
                        if (matcher.matches()) {
                            this.add(HeaderLogEntry.create(matcher.group(1)));
                            continue block22;
                        }
                        throw new IllegalArgumentException("Unsupported access log format entry: " + format);
                    }
                }
            }
            return this;
        }

        public Builder add(AccessLogEntry entry) {
            this.entries.add(entry);
            return this;
        }

        public Builder enabled(boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public Builder config(Config config) {
            config.get("enabled").asBoolean().ifPresent(this::enabled);
            config.get("logger-name").asString().ifPresent(this::loggerName);
            config.get("format").asString().ifPresent(this::configLogFormat);
            return this;
        }

        public Builder loggerName(String loggerName) {
            this.loggerName = loggerName;
            return this;
        }

        public Builder clock(Clock clock) {
            this.clock = clock;
            return this;
        }

        private void configLogFormat(String format) {
            switch (format) {
                case "common": {
                    this.commonLogFormat();
                    break;
                }
                case "helidon": {
                    this.helidonLogFormat();
                    break;
                }
                default: {
                    this.logFormatString(format);
                }
            }
        }
    }
}

