/*
 * Copyright (c) 2025 Oracle and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package io.helidon.webclient.websocket;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

import io.helidon.builder.api.Prototype;
import io.helidon.common.Generated;
import io.helidon.common.config.Config;

/**
 * Configuration of an HTTP/1.1 client.
 *
 * @see #builder()
 * @see #create()
 */
@Generated(value = "io.helidon.builder.codegen.BuilderCodegen", trigger = "io.helidon.webclient.websocket.WsClientProtocolConfigBlueprint")
public interface WsClientProtocolConfig extends WsClientProtocolConfigBlueprint, Prototype.Api {

    /**
     * Create a new fluent API builder to customize configuration.
     *
     * @return a new builder
     */
    static WsClientProtocolConfig.Builder builder() {
        return new WsClientProtocolConfig.Builder();
    }

    /**
     * Create a new fluent API builder from an existing instance.
     *
     * @param instance an existing instance used as a base for the builder
     * @return a builder based on an instance
     */
    static WsClientProtocolConfig.Builder builder(WsClientProtocolConfig instance) {
        return WsClientProtocolConfig.builder().from(instance);
    }

    /**
     * Create a new instance from configuration.
     *
     * @param config used to configure the new instance
     * @return a new instance configured from configuration
     */
    static WsClientProtocolConfig create(Config config) {
        return WsClientProtocolConfig.builder().config(config).buildPrototype();
    }

    /**
     * Create a new instance with default values.
     *
     * @return a new instance
     */
    static WsClientProtocolConfig create() {
        return WsClientProtocolConfig.builder().buildPrototype();
    }

    /**
     * Fluent API builder base for {@link WsClientProtocolConfig}.
     *
     * @param <BUILDER> type of the builder extending this abstract builder
     * @param <PROTOTYPE> type of the prototype interface that would be built by {@link #buildPrototype()}
     */
    abstract class BuilderBase<BUILDER extends WsClientProtocolConfig.BuilderBase<BUILDER, PROTOTYPE>, PROTOTYPE extends WsClientProtocolConfig> implements Prototype.ConfiguredBuilder<BUILDER, PROTOTYPE> {

        private final List<String> subProtocols = new ArrayList<>();
        private boolean isSubProtocolsMutated;
        private Config config;
        private String name = "websocket";

        /**
         * Protected to support extensibility.
         */
        protected BuilderBase() {
        }

        /**
         * Update this builder from an existing prototype instance. This method disables automatic service discovery.
         *
         * @param prototype existing prototype to update this builder from
         * @return updated builder instance
         */
        public BUILDER from(WsClientProtocolConfig prototype) {
            name(prototype.name());
            if (!isSubProtocolsMutated) {
                subProtocols.clear();
            }
            addSubProtocols(prototype.subProtocols());
            return self();
        }

        /**
         * Update this builder from an existing prototype builder instance.
         *
         * @param builder existing builder prototype to update this builder from
         * @return updated builder instance
         */
        public BUILDER from(WsClientProtocolConfig.BuilderBase<?, ?> builder) {
            name(builder.name());
            if (isSubProtocolsMutated) {
                if (builder.isSubProtocolsMutated) {
                    addSubProtocols(builder.subProtocols);
                }
            } else {
                subProtocols.clear();
                addSubProtocols(builder.subProtocols);
            }
            return self();
        }

        /**
         * Update builder from configuration (node of this type).
         * If a value is present in configuration, it would override currently configured values.
         *
         * @param config configuration instance used to obtain values to update this builder
         * @return updated builder instance
         */
        @Override
        public BUILDER config(Config config) {
            Objects.requireNonNull(config);
            this.config = config;
            config.get("name").as(String.class).ifPresent(this::name);
            config.get("sub-protocols").asList(String.class).ifPresent(this::subProtocols);
            return self();
        }

        /**
         *
         *
         * @param name
         * @return updated builder instance
         * @see #name()
         */
        public BUILDER name(String name) {
            Objects.requireNonNull(name);
            this.name = name;
            return self();
        }

        /**
         *
         *
         * @param subProtocols
         * @return updated builder instance
         * @see #subProtocols()
         */
        public BUILDER subProtocols(List<? extends String> subProtocols) {
            Objects.requireNonNull(subProtocols);
            isSubProtocolsMutated = true;
            this.subProtocols.clear();
            this.subProtocols.addAll(subProtocols);
            return self();
        }

        /**
         *
         *
         * @param subProtocols
         * @return updated builder instance
         * @see #subProtocols()
         */
        public BUILDER addSubProtocols(List<? extends String> subProtocols) {
            Objects.requireNonNull(subProtocols);
            isSubProtocolsMutated = true;
            this.subProtocols.addAll(subProtocols);
            return self();
        }

        /**
         *
         *
         * @param subProtocol
         * @return updated builder instance
         * @see #subProtocols()
         */
        public BUILDER addSubProtocol(String subProtocol) {
            Objects.requireNonNull(subProtocol);
            this.subProtocols.add(subProtocol);
            isSubProtocolsMutated = true;
            return self();
        }

        /**
         *
         *
         * @return the name
         */
        public String name() {
            return name;
        }

        /**
         *
         *
         * @return the sub protocols
         */
        public List<String> subProtocols() {
            return subProtocols;
        }

        /**
         * If this instance was configured, this would be the config instance used.
         *
         * @return config node used to configure this builder, or empty if not configured
         */
        public Optional<Config> config() {
            return Optional.ofNullable(config);
        }

        @Override
        public String toString() {
            return "WsClientProtocolConfigBuilder{"
                    + "name=" + name + ","
                    + "subProtocols=" + subProtocols
                    + "}";
        }

        /**
         * Handles providers and decorators.
         */
        protected void preBuildPrototype() {
        }

        /**
         * Validates required properties.
         */
        protected void validatePrototype() {
        }

        /**
         * Generated implementation of the prototype, can be extended by descendant prototype implementations.
         */
        protected static class WsClientProtocolConfigImpl implements WsClientProtocolConfig {

            private final List<String> subProtocols;
            private final String name;

            /**
             * Create an instance providing a builder.
             *
             * @param builder extending builder base of this prototype
             */
            protected WsClientProtocolConfigImpl(WsClientProtocolConfig.BuilderBase<?, ?> builder) {
                this.name = builder.name();
                this.subProtocols = List.copyOf(builder.subProtocols());
            }

            @Override
            public String name() {
                return name;
            }

            @Override
            public List<String> subProtocols() {
                return subProtocols;
            }

            @Override
            public String toString() {
                return "WsClientProtocolConfig{"
                        + "name=" + name + ","
                        + "subProtocols=" + subProtocols
                        + "}";
            }

            @Override
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof WsClientProtocolConfig other)) {
                    return false;
                }
                return Objects.equals(name, other.name())
                    && Objects.equals(subProtocols, other.subProtocols());
            }

            @Override
            public int hashCode() {
                return Objects.hash(name, subProtocols);
            }

        }

    }

    /**
     * Fluent API builder for {@link WsClientProtocolConfig}.
     */
    class Builder extends WsClientProtocolConfig.BuilderBase<WsClientProtocolConfig.Builder, WsClientProtocolConfig> implements io.helidon.common.Builder<WsClientProtocolConfig.Builder, WsClientProtocolConfig> {

        private Builder() {
        }

        @Override
        public WsClientProtocolConfig buildPrototype() {
            preBuildPrototype();
            validatePrototype();
            return new WsClientProtocolConfigImpl(this);
        }

        @Override
        public WsClientProtocolConfig build() {
            return buildPrototype();
        }

    }

}
