/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webclient.tracing;

import io.helidon.common.context.Context;
import io.helidon.http.ClientRequestHeaders;
import io.helidon.http.Http;
import io.helidon.tracing.HeaderConsumer;
import io.helidon.tracing.HeaderProvider;
import io.helidon.tracing.Span;
import io.helidon.tracing.SpanContext;
import io.helidon.tracing.Tag;
import io.helidon.tracing.Tracer;
import io.helidon.webclient.api.ClientUri;
import io.helidon.webclient.api.WebClientServiceRequest;
import io.helidon.webclient.api.WebClientServiceResponse;
import io.helidon.webclient.spi.WebClientService;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;

public class WebClientTracing
implements WebClientService {
    private final Function<Context, Tracer> tracerFunction;

    private WebClientTracing() {
        this.tracerFunction = ctx -> ctx.get(Tracer.class).orElseGet(Tracer::global);
    }

    private WebClientTracing(Tracer tracer) {
        this.tracerFunction = ctx -> tracer;
    }

    public static WebClientService create() {
        return new WebClientTracing();
    }

    public static WebClientService create(Tracer tracer) {
        return new WebClientTracing(tracer);
    }

    public WebClientServiceResponse handle(WebClientService.Chain chain, WebClientServiceRequest request) {
        String method = request.method().text();
        Tracer tracer = this.tracerFunction.apply(request.context());
        ClientUri uriInfo = request.uri();
        String url = uriInfo.scheme() + "://" + uriInfo.authority() + uriInfo.path().path();
        Span.Builder spanBuilder = tracer.spanBuilder(method + "-" + url);
        request.context().get(SpanContext.class).ifPresent(arg_0 -> ((Span.Builder)spanBuilder).parent(arg_0));
        spanBuilder.kind(Span.Kind.CLIENT);
        spanBuilder.tag(Tag.COMPONENT.create((Object)"helidon-webclient"));
        spanBuilder.tag(Tag.HTTP_METHOD.create((Object)method));
        spanBuilder.tag(Tag.HTTP_URL.create((Object)url));
        Span span = spanBuilder.start();
        request.context().register((Object)span.context());
        tracer.inject(span.context(), HeaderProvider.empty(), (HeaderConsumer)new ClientHeaderConsumer(request.headers()));
        try {
            WebClientServiceResponse response = chain.proceed(request);
            Http.Status status = response.status();
            span.tag(Tag.HTTP_STATUS.create((Object)status.code()));
            Http.Status.Family family = status.family();
            if (status.code() >= 400) {
                String errorKind = family == Http.Status.Family.CLIENT_ERROR ? "ClientError" : "ServerError";
                span.addEvent("error", Map.of("message", "Response HTTP status: " + String.valueOf(status), "error.kind", errorKind));
            }
            span.end();
            return response;
        }
        catch (Throwable e) {
            span.end(e);
            throw e;
        }
    }

    private static class ClientHeaderConsumer
    implements HeaderConsumer {
        private final ClientRequestHeaders headers;

        private ClientHeaderConsumer(ClientRequestHeaders headers) {
            this.headers = headers;
        }

        public void setIfAbsent(String key, String ... values) {
            Http.HeaderName name = Http.HeaderNames.create((String)key);
            if (!this.headers.contains(name)) {
                this.headers.set(name, values);
            }
        }

        public void set(String key, String ... values) {
            this.headers.set(Http.Headers.create((String)key, (String[])values));
        }

        public Iterable<String> keys() {
            return this.headers.stream().map(Http.Header::name).toList();
        }

        public Optional<String> get(String key) {
            return this.headers.first(Http.HeaderNames.create((String)key));
        }

        public Iterable<String> getAll(String key) {
            return this.headers.all(Http.HeaderNames.create((String)key), List::of);
        }

        public boolean contains(String key) {
            return this.headers.contains(Http.HeaderNames.create((String)key));
        }
    }
}

