/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webclient.sse;

import io.helidon.common.GenericType;
import io.helidon.common.media.type.MediaTypes;
import io.helidon.http.media.MediaContext;
import io.helidon.http.sse.SseEvent;
import io.helidon.webclient.api.HttpClientResponse;
import io.helidon.webclient.spi.Source;
import io.helidon.webclient.spi.SourceHandlerProvider;
import io.helidon.webclient.sse.SseSource;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.time.Duration;

public class SseSourceHandlerProvider
implements SourceHandlerProvider<SseEvent> {
    private static final char BOM = '\ufeff';
    private static final String ID = "id:";
    private static final String DATA = "data:";
    private static final String RETRY = "retry:";
    private static final String EVENT = "event:";

    public boolean supports(GenericType<? extends Source<?>> type, HttpClientResponse response) {
        return SseSource.TYPE.equals(type) && response.headers().contentType().map(ct -> ct.mediaType().equals((Object)MediaTypes.TEXT_EVENT_STREAM)).orElse(false) != false;
    }

    public <X extends Source<SseEvent>> void handle(X source, HttpClientResponse response, MediaContext mediaContext) {
        InputStream is = response.inputStream();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));){
            String line;
            boolean emit = false;
            boolean first = true;
            StringBuilder data = new StringBuilder();
            SseEvent.Builder sseBuilder = SseEvent.builder().mediaContext(mediaContext);
            source.onOpen();
            while ((line = reader.readLine()) != null) {
                if (first && line.charAt(0) == '\ufeff') {
                    line = line.substring(1);
                }
                first = false;
                if (line.isBlank()) {
                    if (!emit) continue;
                    sseBuilder.data((Object)data.toString());
                    source.onEvent((Object)sseBuilder.build());
                    data.setLength(0);
                    sseBuilder = SseEvent.builder();
                    emit = false;
                    continue;
                }
                emit = true;
                if (line.startsWith(DATA)) {
                    data.append(SseSourceHandlerProvider.skipPrefix(line));
                    continue;
                }
                if (line.startsWith(EVENT)) {
                    sseBuilder.name(SseSourceHandlerProvider.skipPrefix(line));
                    continue;
                }
                if (line.startsWith(ID)) {
                    sseBuilder.id(SseSourceHandlerProvider.skipPrefix(line));
                    continue;
                }
                if (line.startsWith(RETRY)) {
                    long delay = Long.parseLong(SseSourceHandlerProvider.skipPrefix(line));
                    sseBuilder.reconnectDelay(Duration.ofMillis(delay));
                    continue;
                }
                if (line.startsWith(":")) {
                    sseBuilder.comment(line.length() > 1 ? line.substring(1) : "");
                    continue;
                }
                emit = false;
            }
            source.onClose();
        }
        catch (IOException e) {
            source.onError((Throwable)e);
            throw new UncheckedIOException(e);
        }
        catch (NumberFormatException e) {
            source.onError((Throwable)e);
            throw e;
        }
    }

    private static String skipPrefix(String line) {
        StringBuilder builder = new StringBuilder(line.length());
        int state = 0;
        block5: for (int i = 0; i < line.length(); ++i) {
            switch (state) {
                case 0: {
                    if (line.charAt(i) != ':') continue block5;
                    state = 1;
                    continue block5;
                }
                case 1: {
                    char ch = line.charAt(i);
                    if (ch == ' ') continue block5;
                    builder.append(ch);
                    state = 2;
                    continue block5;
                }
                case 2: {
                    builder.append(line.charAt(i));
                    continue block5;
                }
                default: {
                    throw new IllegalStateException("Illegal SSE parser state for text/event-stream");
                }
            }
        }
        return builder.toString();
    }
}

