/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webclient.metrics;

import io.helidon.common.config.Config;
import io.helidon.http.Method;
import io.helidon.metrics.api.MeterRegistry;
import io.helidon.metrics.api.Metrics;
import io.helidon.webclient.api.WebClientServiceRequest;
import io.helidon.webclient.api.WebClientServiceResponse;
import io.helidon.webclient.metrics.WebClientMetricType;
import io.helidon.webclient.spi.WebClientService;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;

abstract class WebClientMetric
implements WebClientService {
    private static final int ERROR_STATUS_CODE = 400;
    private final MeterRegistry registry = Metrics.globalRegistry();
    private final Set<String> methods;
    private final String nameFormat;
    private final String description;
    private final boolean success;
    private final boolean errors;

    WebClientMetric(Builder builder) {
        this.methods = builder.methods;
        this.nameFormat = builder.nameFormat;
        this.description = builder.description;
        this.success = builder.success;
        this.errors = builder.errors;
    }

    static Builder builder(WebClientMetricType clientMetricType) {
        return new Builder(clientMetricType);
    }

    public String type() {
        return "metrics";
    }

    MeterRegistry meterRegistry() {
        return this.registry;
    }

    Set<String> methods() {
        return this.methods;
    }

    String nameFormat() {
        return this.nameFormat;
    }

    String description() {
        return this.description;
    }

    boolean measureSuccess() {
        return this.success;
    }

    boolean measureErrors() {
        return this.errors;
    }

    boolean shouldContinueOnSuccess(Method method, int status) {
        return this.handlesMethod(method) && this.measureSuccess() && status < 400;
    }

    boolean shouldContinueOnError(Method method) {
        return this.handlesMethod(method) && this.measureErrors();
    }

    boolean shouldContinueOnError(Method method, int status) {
        if (status >= 400) {
            return this.shouldContinueOnError(method);
        }
        return false;
    }

    Metadata createMetadata(WebClientServiceRequest request, WebClientServiceResponse response) {
        String name = response == null ? this.createName(request) : this.createName(request, response);
        Metadata.Builder builder = Metadata.builder().withName(name);
        if (this.description != null) {
            builder = builder.withDescription(this.description);
        }
        return builder.build();
    }

    String createName(WebClientServiceRequest request, WebClientServiceResponse response) {
        return String.format(this.nameFormat(), request.method().text(), request.uri().host(), response.status().code());
    }

    String createName(WebClientServiceRequest request) {
        return String.format(this.nameFormat(), request.method().text(), request.uri().host());
    }

    boolean handlesMethod(Method method) {
        return this.methods().isEmpty() || this.methods().contains(method.text());
    }

    public static final class Builder
    implements io.helidon.common.Builder<Builder, WebClientMetric> {
        private final WebClientMetricType type;
        private Set<String> methods = Collections.emptySet();
        private String nameFormat;
        private String description;
        private boolean success = true;
        private boolean errors = true;

        private Builder(WebClientMetricType type) {
            this.type = type;
        }

        public Builder methods(String ... methods) {
            this.methods = Arrays.stream(methods).map(String::toUpperCase).collect(Collectors.toSet());
            return this;
        }

        public Builder methods(Method ... methods) {
            this.methods = Arrays.stream(methods).map(Method::text).map(String::toUpperCase).collect(Collectors.toSet());
            return this;
        }

        public Builder methods(Collection<String> methods) {
            this.methods = methods.stream().map(String::toUpperCase).collect(Collectors.toSet());
            return this;
        }

        public Builder nameFormat(String nameFormat) {
            this.nameFormat = nameFormat;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder success(boolean success) {
            this.success = success;
            return this;
        }

        public Builder errors(boolean errors) {
            this.errors = errors;
            return this;
        }

        public Builder config(Config config) {
            config.get("methods").asList(String.class).ifPresent(this::methods);
            config.get("errors").asBoolean().ifPresent(this::errors);
            config.get("success").asBoolean().ifPresent(this::success);
            config.get("name-format").asString().ifPresent(this::nameFormat);
            config.get("description").asString().ifPresent(this::description);
            return this;
        }

        public WebClientMetric build() {
            return this.type.createInstance(this);
        }
    }

    record Metadata(String name, String description) {
        static Builder builder() {
            return new Builder();
        }

        static class Builder {
            private String name;
            private String description;

            Builder() {
            }

            Builder withName(String name) {
                this.name = name;
                return this;
            }

            Builder withDescription(String description) {
                this.description = description;
                return this;
            }

            Metadata build() {
                return new Metadata(this.name, this.description);
            }
        }
    }
}

