/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webclient.metrics;

import io.helidon.http.Http;
import io.helidon.metrics.api.Meter;
import io.helidon.metrics.api.Timer;
import io.helidon.webclient.api.WebClientServiceRequest;
import io.helidon.webclient.api.WebClientServiceResponse;
import io.helidon.webclient.metrics.WebClientMetric;
import io.helidon.webclient.spi.WebClientService;
import java.time.Duration;

class WebClientTimer
extends WebClientMetric {
    WebClientTimer(WebClientMetric.Builder builder) {
        super(builder);
    }

    public WebClientServiceResponse handle(WebClientService.Chain chain, WebClientServiceRequest request) {
        long start = System.nanoTime();
        Http.Method method = request.method();
        try {
            WebClientServiceResponse response = chain.proceed(request);
            Http.Status status = response.status();
            if (this.shouldContinueOnError(method, status.code())) {
                this.updateTimer(this.createMetadata(request, response), start);
            }
            return response;
        }
        catch (Throwable ex) {
            if (this.shouldContinueOnError(method)) {
                this.updateTimer(this.createMetadata(request, null), start);
            }
            throw ex;
        }
    }

    private void updateTimer(WebClientMetric.Metadata metadata, long start) {
        long time = System.nanoTime() - start;
        Timer timer = (Timer)this.meterRegistry().getOrCreate((Meter.Builder)((Timer.Builder)Timer.builder((String)metadata.name()).description(metadata.description())));
        timer.record(Duration.ofNanos(time));
    }
}

