/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webclient.metrics;

import io.helidon.common.http.Http;
import io.helidon.webclient.WebClientServiceRequest;
import io.helidon.webclient.metrics.WebClientMetric;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.Meter;
import org.eclipse.microprofile.metrics.MetricType;

public class WebClientMeter
extends WebClientMetric {
    WebClientMeter(WebClientMetric.Builder builder) {
        super(builder);
    }

    @Override
    MetricType metricType() {
        return MetricType.METERED;
    }

    public CompletionStage<WebClientServiceRequest> request(WebClientServiceRequest request) {
        Http.RequestMethod method = request.method();
        request.whenResponseReceived().thenAccept(response -> {
            if (this.shouldContinueOnError(method, response.status().code())) {
                this.updateMeter(this.createMetadata(request, null));
            }
        });
        request.whenComplete().thenAccept(response -> {
            if (this.shouldContinueOnSuccess(method, response.status().code())) {
                this.updateMeter(this.createMetadata(request, null));
            }
        }).exceptionally(throwable -> {
            if (this.shouldContinueOnError(method)) {
                this.updateMeter(this.createMetadata(request, null));
            }
            return null;
        });
        return CompletableFuture.completedFuture(request);
    }

    private void updateMeter(Metadata metadata) {
        Meter meter = this.metricRegistry().meter(metadata);
        meter.mark();
    }
}

