/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webclient.metrics;

import io.helidon.webclient.WebClientServiceRequest;
import io.helidon.webclient.metrics.WebClientMetric;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.eclipse.microprofile.metrics.ConcurrentGauge;
import org.eclipse.microprofile.metrics.MetricType;

class WebClientGaugeInProgress
extends WebClientMetric {
    WebClientGaugeInProgress(WebClientMetric.Builder builder) {
        super(builder);
    }

    @Override
    MetricType metricType() {
        return MetricType.CONCURRENT_GAUGE;
    }

    public CompletionStage<WebClientServiceRequest> request(WebClientServiceRequest request) {
        ConcurrentGauge gauge = this.metricRegistry().concurrentGauge(this.createMetadata(request, null));
        boolean shouldBeHandled = this.handlesMethod(request.method());
        if (!shouldBeHandled) {
            return CompletableFuture.completedFuture(request);
        }
        gauge.inc();
        request.whenComplete().thenAccept(response -> gauge.dec()).exceptionally(throwable -> {
            gauge.dec();
            return null;
        });
        return CompletableFuture.completedFuture(request);
    }
}

