/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webclient.metrics;

import io.helidon.common.http.Http;
import io.helidon.webclient.WebClientServiceRequest;
import io.helidon.webclient.WebClientServiceResponse;
import io.helidon.webclient.metrics.WebClientMetric;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.eclipse.microprofile.metrics.Counter;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.MetricType;

class WebClientCounter
extends WebClientMetric {
    WebClientCounter(WebClientMetric.Builder builder) {
        super(builder);
    }

    @Override
    MetricType metricType() {
        return MetricType.COUNTER;
    }

    public CompletionStage<WebClientServiceRequest> request(WebClientServiceRequest request) {
        Http.RequestMethod method = request.method();
        request.whenResponseReceived().thenAccept(response -> {
            if (this.shouldContinueOnError(method, response.status().code())) {
                this.updateCounter(this.createMetadata(request, (WebClientServiceResponse)response));
            }
        });
        request.whenComplete().thenAccept(response -> {
            if (this.shouldContinueOnSuccess(method, response.status().code())) {
                this.updateCounter(this.createMetadata(request, (WebClientServiceResponse)response));
            }
        }).exceptionally(throwable -> {
            if (this.shouldContinueOnError(method)) {
                this.updateCounter(this.createMetadata(request, null));
            }
            return null;
        });
        return CompletableFuture.completedFuture(request);
    }

    private void updateCounter(Metadata metadata) {
        Counter counter = this.metricRegistry().counter(metadata);
        counter.inc();
    }
}

