/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webclient.jsonrpc;

import io.helidon.common.GenericType;
import io.helidon.http.ClientResponseHeaders;
import io.helidon.http.ClientResponseTrailers;
import io.helidon.http.HeaderNames;
import io.helidon.http.Status;
import io.helidon.http.media.ReadableEntity;
import io.helidon.jsonrpc.core.JsonUtil;
import io.helidon.webclient.api.ClientUri;
import io.helidon.webclient.api.HttpClientResponse;
import io.helidon.webclient.jsonrpc.JsonRpcClientBatchResponse;
import io.helidon.webclient.jsonrpc.JsonRpcClientResponse;
import io.helidon.webclient.jsonrpc.JsonRpcClientResponseImpl;
import io.helidon.webclient.spi.Source;
import jakarta.json.JsonArray;
import jakarta.json.JsonObject;
import jakarta.json.JsonValue;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;

class JsonRpcClientBatchResponseImpl
implements JsonRpcClientBatchResponse {
    private static final JsonArray EMPTY_JSON_ARRAY = JsonUtil.JSON_BUILDER_FACTORY.createArrayBuilder().build();
    private final HttpClientResponse delegate;
    private JsonArray jsonArray;
    private List<JsonRpcClientResponse> responses;

    JsonRpcClientBatchResponseImpl(HttpClientResponse delegate) {
        this.delegate = delegate;
    }

    @Override
    public int size() {
        return this.asJsonArray().size();
    }

    @Override
    public JsonRpcClientResponse get(int index) {
        if (this.responses == null) {
            this.responses = new ArrayList<JsonRpcClientResponse>();
            JsonArray array = this.asJsonArray();
            for (JsonValue jsonValue : array) {
                JsonObject object = jsonValue.asJsonObject();
                this.responses.add(new JsonRpcClientResponseImpl(this.delegate, object));
            }
        }
        return this.responses.get(index);
    }

    @Override
    public Iterator<JsonRpcClientResponse> iterator() {
        final JsonArray array = this.asJsonArray();
        return new Iterator<JsonRpcClientResponse>(){
            private int index = 0;

            @Override
            public boolean hasNext() {
                return array.size() > this.index;
            }

            @Override
            public JsonRpcClientResponse next() {
                return JsonRpcClientBatchResponseImpl.this.get(this.index++);
            }
        };
    }

    public JsonArray asJsonArray() {
        if (this.jsonArray == null) {
            ClientResponseHeaders headers = this.delegate.headers();
            if (headers.contains(HeaderNames.CONTENT_TYPE)) {
                Optional contentType = headers.first(HeaderNames.CONTENT_TYPE);
                if (contentType.isEmpty() || !((String)contentType.get()).equalsIgnoreCase("application/json")) {
                    throw new IllegalStateException("Response contains invalid Content-Type header");
                }
                this.jsonArray = (JsonArray)this.delegate.entity().as(JsonArray.class);
            } else {
                this.jsonArray = EMPTY_JSON_ARRAY;
            }
        }
        return this.jsonArray;
    }

    public ReadableEntity entity() {
        return this.delegate.entity();
    }

    public InputStream inputStream() {
        return this.delegate.inputStream();
    }

    public <T> T as(Class<T> type) {
        return (T)this.delegate.as(type);
    }

    public <T extends Source<?>> void source(GenericType<T> sourceType, T source) {
        this.delegate.source(sourceType, source);
    }

    public void close() {
        this.delegate.close();
    }

    public Status status() {
        return this.delegate.status();
    }

    public ClientResponseHeaders headers() {
        return this.delegate.headers();
    }

    public ClientResponseTrailers trailers() {
        return this.delegate.trailers();
    }

    public ClientUri lastEndpointUri() {
        return this.delegate.lastEndpointUri();
    }
}

