/*
 * Copyright (c) 2025 Oracle and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package io.helidon.webclient.jsonrpc;

import java.util.Objects;
import java.util.Optional;

import io.helidon.builder.api.Prototype;
import io.helidon.common.Generated;
import io.helidon.config.Config;
import io.helidon.config.ConfigBuilderSupport;

/**
 * Configuration of a JSON-RPC client.
 *
 * @see #builder()
 * @see #create()
 */
@Generated(value = "io.helidon.builder.codegen.BuilderCodegen", trigger = "io.helidon.webclient.jsonrpc.JsonRpcClientProtocolConfigBlueprint")
public interface JsonRpcClientProtocolConfig extends JsonRpcClientProtocolConfigBlueprint, Prototype.Api {

    /**
     * Create a new fluent API builder to customize configuration.
     *
     * @return a new builder
     */
    static JsonRpcClientProtocolConfig.Builder builder() {
        return new JsonRpcClientProtocolConfig.Builder();
    }

    /**
     * Create a new fluent API builder from an existing instance.
     *
     * @param instance an existing instance used as a base for the builder
     * @return a builder based on an instance
     */
    static JsonRpcClientProtocolConfig.Builder builder(JsonRpcClientProtocolConfig instance) {
        return JsonRpcClientProtocolConfig.builder().from(instance);
    }

    /**
     * Create a new instance from configuration.
     *
     * @param config used to configure the new instance
     * @return a new instance configured from configuration
     */
    static JsonRpcClientProtocolConfig create(Config config) {
        return JsonRpcClientProtocolConfig.builder().config(config).buildPrototype();
    }

    /**
     * Create a new instance from configuration.
     *
     * @param config used to configure the new instance
     * @return a new instance configured from configuration
     * @deprecated use {@link #create(io.helidon.config.Config)}
     */
    @Deprecated
    static JsonRpcClientProtocolConfig create(io.helidon.common.config.Config config) {
        return create(Config.config(config));
    }

    /**
     * Create a new instance with default values.
     *
     * @return a new instance
     */
    static JsonRpcClientProtocolConfig create() {
        return JsonRpcClientProtocolConfig.builder().buildPrototype();
    }

    /**
     * Name identifying this client protocol. Defaults to type.
     *
     * @return name of client protocol
     */
    @Override
    String name();

    /**
     * Fluent API builder base for {@link JsonRpcClientProtocolConfig}.
     *
     * @param <BUILDER> type of the builder extending this abstract builder
     * @param <PROTOTYPE> type of the prototype interface that would be built by {@link #buildPrototype()}
     */
    abstract class BuilderBase<BUILDER extends JsonRpcClientProtocolConfig.BuilderBase<BUILDER, PROTOTYPE>, PROTOTYPE extends JsonRpcClientProtocolConfig> implements ConfigBuilderSupport.ConfiguredBuilder<BUILDER, PROTOTYPE> {

        private Config config;
        private String name = "jsonrpc";

        /**
         * Protected to support extensibility.
         */
        protected BuilderBase() {
        }

        /**
         * Update this builder from an existing prototype instance. This method disables automatic service discovery.
         *
         * @param prototype existing prototype to update this builder from
         * @return updated builder instance
         */
        public BUILDER from(JsonRpcClientProtocolConfig prototype) {
            name(prototype.name());
            return self();
        }

        /**
         * Update this builder from an existing prototype builder instance.
         *
         * @param builder existing builder prototype to update this builder from
         * @return updated builder instance
         */
        public BUILDER from(JsonRpcClientProtocolConfig.BuilderBase<?, ?> builder) {
            name(builder.name());
            return self();
        }

        /**
         * Update builder from configuration (node of this type).
         * If a value is present in configuration, it would override currently configured values.
         *
         * @param config configuration instance used to obtain values to update this builder
         * @return updated builder instance
         * @deprecated use {@link #config(io.helidon.config.Config)}
         */
        @Deprecated
        public BUILDER config(io.helidon.common.config.Config config) {
            return config(Config.config(config));
        }

        /**
         * Update builder from configuration (node of this type).
         * If a value is present in configuration, it would override currently configured values.
         *
         * @param config configuration instance used to obtain values to update this builder
         * @return updated builder instance
         */
        @Override
        public BUILDER config(Config config) {
            Objects.requireNonNull(config);
            this.config = config;
            config.get("name").as(String.class).ifPresent(this::name);
            return self();
        }

        /**
         * Name identifying this client protocol. Defaults to type.
         *
         * @param name name of client protocol
         * @return updated builder instance
         * @see #name()
         */
        public BUILDER name(String name) {
            Objects.requireNonNull(name);
            this.name = name;
            return self();
        }

        /**
         * Name identifying this client protocol. Defaults to type.
         *
         * @return the name
         */
        public String name() {
            return name;
        }

        /**
         * If this instance was configured, this would be the config instance used.
         *
         * @return config node used to configure this builder, or empty if not configured
         */
        public Optional<io.helidon.common.config.Config> config() {
            return Optional.ofNullable(config);
        }

        @Override
        public String toString() {
            return "JsonRpcClientProtocolConfigBuilder{"
                    + "name=" + name
                    + "}";
        }

        /**
         * Handles providers and decorators.
         */
        protected void preBuildPrototype() {
        }

        /**
         * Validates required properties.
         */
        protected void validatePrototype() {
        }

        /**
         * Generated implementation of the prototype, can be extended by descendant prototype implementations.
         */
        protected static class JsonRpcClientProtocolConfigImpl implements JsonRpcClientProtocolConfig {

            private final String name;

            /**
             * Create an instance providing a builder.
             *
             * @param builder extending builder base of this prototype
             */
            protected JsonRpcClientProtocolConfigImpl(JsonRpcClientProtocolConfig.BuilderBase<?, ?> builder) {
                this.name = builder.name();
            }

            @Override
            public String name() {
                return name;
            }

            @Override
            public String toString() {
                return "JsonRpcClientProtocolConfig{"
                        + "name=" + name
                        + "}";
            }

            @Override
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof JsonRpcClientProtocolConfig other)) {
                    return false;
                }
                return Objects.equals(name, other.name());
            }

            @Override
            public int hashCode() {
                return Objects.hash(name);
            }

        }

    }

    /**
     * Fluent API builder for {@link JsonRpcClientProtocolConfig}.
     */
    class Builder extends JsonRpcClientProtocolConfig.BuilderBase<JsonRpcClientProtocolConfig.Builder, JsonRpcClientProtocolConfig> implements io.helidon.common.Builder<JsonRpcClientProtocolConfig.Builder, JsonRpcClientProtocolConfig> {

        private Builder() {
        }

        @Override
        public JsonRpcClientProtocolConfig buildPrototype() {
            preBuildPrototype();
            validatePrototype();
            return new JsonRpcClientProtocolConfigImpl(this);
        }

        @Override
        public JsonRpcClientProtocolConfig build() {
            return buildPrototype();
        }

    }

}
