/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webclient.jsonrpc;

import io.helidon.common.media.type.MediaType;
import io.helidon.common.tls.Tls;
import io.helidon.common.uri.UriFragment;
import io.helidon.common.uri.UriInfo;
import io.helidon.http.ClientRequestHeaders;
import io.helidon.http.Header;
import io.helidon.http.HeaderName;
import io.helidon.http.HeaderNames;
import io.helidon.http.Headers;
import io.helidon.http.HttpException;
import io.helidon.http.HttpMediaType;
import io.helidon.jsonrpc.core.JsonUtil;
import io.helidon.webclient.api.ClientConnection;
import io.helidon.webclient.api.ClientRequest;
import io.helidon.webclient.api.ClientResponseTyped;
import io.helidon.webclient.api.ClientUri;
import io.helidon.webclient.api.HttpClientResponse;
import io.helidon.webclient.api.Proxy;
import io.helidon.webclient.http1.Http1Client;
import io.helidon.webclient.http1.Http1ClientRequest;
import io.helidon.webclient.http1.Http1ClientResponse;
import io.helidon.webclient.jsonrpc.JsonRpcClientBatchRequest;
import io.helidon.webclient.jsonrpc.JsonRpcClientBatchRequestImpl;
import io.helidon.webclient.jsonrpc.JsonRpcClientRequest;
import io.helidon.webclient.jsonrpc.JsonRpcClientResponse;
import io.helidon.webclient.jsonrpc.JsonRpcClientResponseImpl;
import jakarta.json.JsonArrayBuilder;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonValue;
import java.net.URI;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

class JsonRpcClientRequestImpl
implements JsonRpcClientRequest {
    private final Http1ClientRequest delegate;
    private final JsonRpcClientBatchRequestImpl batch;
    private JsonValue rpcId;
    private String rpcMethod;
    private Map<String, JsonValue> namedParams;
    private List<JsonValue> arrayParams;

    JsonRpcClientRequestImpl(Http1Client http1Client, String rpcMethod) {
        this(http1Client, rpcMethod, null);
    }

    JsonRpcClientRequestImpl(Http1Client http1Client, String rpcMethod, JsonRpcClientBatchRequestImpl batch) {
        Objects.requireNonNull(http1Client, "delegate is null");
        this.delegate = (Http1ClientRequest)http1Client.post();
        this.rpcMethod = rpcMethod;
        this.batch = batch;
    }

    @Override
    public JsonRpcClientRequest rpcMethod(String rpcMethod) {
        this.rpcMethod = rpcMethod;
        return this;
    }

    @Override
    public JsonRpcClientRequest rpcId(JsonValue value) {
        this.rpcId = value;
        return this;
    }

    @Override
    public JsonRpcClientRequest param(String name, JsonValue value) {
        if (this.arrayParams != null) {
            throw new IllegalStateException("Cannot mixed named and array params");
        }
        if (this.namedParams == null) {
            this.namedParams = new HashMap<String, JsonValue>();
        }
        this.namedParams.put(name, value);
        return this;
    }

    @Override
    public JsonRpcClientRequest addParam(JsonValue value) {
        if (this.namedParams != null) {
            throw new IllegalStateException("Cannot mixed named and array params");
        }
        if (this.arrayParams == null) {
            this.arrayParams = new ArrayList<JsonValue>();
        }
        this.arrayParams.add(value);
        return this;
    }

    @Override
    public JsonObject asJsonObject() {
        JsonObjectBuilder builder = JsonUtil.JSON_BUILDER_FACTORY.createObjectBuilder().add("jsonrpc", "2.0");
        if (this.rpcId != null) {
            builder.add("id", this.rpcId);
        }
        builder.add("method", this.rpcMethod);
        if (this.namedParams != null) {
            JsonObjectBuilder namedBuilder = JsonUtil.JSON_BUILDER_FACTORY.createObjectBuilder();
            for (Map.Entry<String, JsonValue> entry : this.namedParams.entrySet()) {
                namedBuilder.add(entry.getKey(), entry.getValue());
            }
            builder.add("params", (JsonValue)namedBuilder.build());
        } else if (this.arrayParams != null) {
            JsonArrayBuilder arrayBuilder = JsonUtil.JSON_BUILDER_FACTORY.createArrayBuilder();
            for (JsonValue value : this.arrayParams) {
                arrayBuilder.add(value);
            }
            builder.add("params", (JsonValue)arrayBuilder.build());
        } else {
            builder.add("params", (JsonValue)JsonUtil.JSON_BUILDER_FACTORY.createObjectBuilder().build());
        }
        return builder.build();
    }

    @Override
    public JsonRpcClientResponse submit() {
        if (this.rpcMethod == null) {
            throw new IllegalStateException("rpcMethod is null");
        }
        Http1ClientResponse res = ((Http1ClientRequest)((Http1ClientRequest)this.delegate.header(HeaderNames.CONTENT_TYPE, new String[]{"application/json"})).header(HeaderNames.ACCEPT, new String[]{"application/json"})).submit((Object)this.asJsonObject());
        return new JsonRpcClientResponseImpl((HttpClientResponse)res);
    }

    @Override
    public JsonRpcClientBatchRequest addToBatch() {
        if (this.batch == null) {
            throw new IllegalStateException("batch is null");
        }
        this.batch.add(this);
        return this.batch;
    }

    public JsonRpcClientRequest uri(String uri) {
        this.delegate.uri(uri);
        return this;
    }

    public JsonRpcClientRequest path(String uri) {
        this.delegate.path(uri);
        return this;
    }

    public JsonRpcClientRequest tls(Tls tls) {
        this.delegate.tls(tls);
        return this;
    }

    public JsonRpcClientRequest proxy(Proxy proxy) {
        this.delegate.proxy(proxy);
        return this;
    }

    public JsonRpcClientRequest uri(URI uri) {
        this.delegate.uri(uri);
        return this;
    }

    public JsonRpcClientRequest uri(ClientUri uri) {
        this.delegate.uri(uri);
        return this;
    }

    public JsonRpcClientRequest header(Header header) {
        this.delegate.header(header);
        return this;
    }

    public JsonRpcClientRequest header(HeaderName name, String ... values) {
        this.delegate.header(name, values);
        return this;
    }

    public JsonRpcClientRequest header(HeaderName name, List<String> values) {
        this.delegate.header(name, values);
        return this;
    }

    public JsonRpcClientRequest headers(Headers headers) {
        this.delegate.headers(headers);
        return this;
    }

    public JsonRpcClientRequest headers(Consumer<ClientRequestHeaders> headersConsumer) {
        this.delegate.headers(headersConsumer);
        return this;
    }

    public JsonRpcClientRequest accept(HttpMediaType ... accepted) {
        this.delegate.accept(accepted);
        return this;
    }

    public JsonRpcClientRequest accept(MediaType ... acceptedTypes) {
        this.delegate.accept(acceptedTypes);
        return this;
    }

    public JsonRpcClientRequest contentType(MediaType contentType) {
        this.delegate.contentType(contentType);
        return this;
    }

    public JsonRpcClientRequest pathParam(String name, String value) {
        this.delegate.pathParam(name, value);
        return this;
    }

    public JsonRpcClientRequest queryParam(String name, String ... values) {
        this.delegate.queryParam(name, values);
        return this;
    }

    public JsonRpcClientRequest fragment(String fragment) {
        this.delegate.fragment(fragment);
        return this;
    }

    public JsonRpcClientRequest fragment(UriFragment fragment) {
        this.delegate.fragment(fragment);
        return this;
    }

    public JsonRpcClientRequest followRedirects(boolean followRedirects) {
        this.delegate.followRedirects(followRedirects);
        return this;
    }

    public JsonRpcClientRequest maxRedirects(int maxRedirects) {
        this.delegate.maxRedirects(maxRedirects);
        return this;
    }

    public boolean followRedirects() {
        return this.delegate.followRedirects();
    }

    public int maxRedirects() {
        return this.delegate.maxRedirects();
    }

    public HttpClientResponse request() {
        return this.delegate.request();
    }

    public ClientRequestHeaders headers() {
        return this.delegate.headers();
    }

    public <E> ClientResponseTyped<E> request(Class<E> type) {
        return this.delegate.request(type);
    }

    public <E> E requestEntity(Class<E> type) throws HttpException {
        return (E)this.delegate.requestEntity(type);
    }

    public HttpClientResponse submit(Object entity) {
        return this.delegate.submit(entity);
    }

    public <T> ClientResponseTyped<T> submit(Object entity, Class<T> requestedType) {
        return this.delegate.submit(entity, requestedType);
    }

    public HttpClientResponse outputStream(ClientRequest.OutputStreamHandler outputStreamConsumer) {
        return this.delegate.outputStream(outputStreamConsumer);
    }

    public <T> ClientResponseTyped<T> outputStream(ClientRequest.OutputStreamHandler outputStreamConsumer, Class<T> requestedType) {
        return this.delegate.outputStream(outputStreamConsumer, requestedType);
    }

    public UriInfo resolvedUri() {
        return this.delegate.resolvedUri();
    }

    public JsonRpcClientRequest connection(ClientConnection connection) {
        this.delegate.connection(connection);
        return this;
    }

    public JsonRpcClientRequest skipUriEncoding(boolean skip) {
        this.delegate.skipUriEncoding(skip);
        return this;
    }

    public JsonRpcClientRequest property(String propertyName, String propertyValue) {
        this.delegate.property(propertyName, propertyValue);
        return this;
    }

    public JsonRpcClientRequest keepAlive(boolean keepAlive) {
        this.delegate.keepAlive(keepAlive);
        return this;
    }

    public JsonRpcClientRequest readTimeout(Duration readTimeout) {
        this.delegate.readTimeout(readTimeout);
        return this;
    }

    public JsonRpcClientRequest readContinueTimeout(Duration readContinueTimeout) {
        this.delegate.readContinueTimeout(readContinueTimeout);
        return this;
    }

    public JsonRpcClientRequest sendExpectContinue(boolean sendExpectContinue) {
        this.delegate.sendExpectContinue(sendExpectContinue);
        return this;
    }
}

