/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webclient.jaxrs;

import io.helidon.common.configurable.ThreadPoolSupplier;
import io.helidon.common.context.Contexts;
import io.helidon.config.Config;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;

public final class JaxRsClient {
    private static final AtomicReference<Supplier<ExecutorService>> EXECUTOR_SUPPLIER = new AtomicReference<ThreadPoolSupplier>(ThreadPoolSupplier.builder().threadNamePrefix("helidon-jaxrs-client-").build());

    private JaxRsClient() {
    }

    public static void configureDefaults(Config config) {
        EXECUTOR_SUPPLIER.set((Supplier<ExecutorService>)ThreadPoolSupplier.create((Config)config, (String)"jaxrs-client-thread-pool"));
    }

    public static void defaultExecutor(Supplier<ExecutorService> executorServiceSupplier) {
        Supplier<ExecutorService> wrapped = () -> Contexts.wrap((ExecutorService)((ExecutorService)executorServiceSupplier.get()));
        EXECUTOR_SUPPLIER.set(wrapped);
    }

    static Supplier<ExecutorService> executor() {
        return EXECUTOR_SUPPLIER.get();
    }
}

