/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webclient.http2;

import io.helidon.common.buffers.BufferData;
import io.helidon.http.ClientRequestHeaders;
import io.helidon.http.ClientResponseHeaders;
import io.helidon.http.ClientResponseTrailers;
import io.helidon.http.Headers;
import io.helidon.http.Status;
import io.helidon.http.media.MediaContext;
import io.helidon.http.media.ReadableEntity;
import io.helidon.webclient.api.ClientResponseEntity;
import io.helidon.webclient.api.ClientUri;
import io.helidon.webclient.api.HttpClientConfig;
import io.helidon.webclient.api.ReleasableResource;
import io.helidon.webclient.http2.Http2ClientResponse;
import io.helidon.webclient.http2.Http2ClientStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;

class Http2ClientResponseImpl
implements Http2ClientResponse {
    private final HttpClientConfig httpClientConfig;
    private final Status responseStatus;
    private final ClientRequestHeaders requestHeaders;
    private final ClientResponseHeaders responseHeaders;
    private final ReleasableResource stream;
    private final CompletableFuture<Void> complete;
    private final Runnable closeResponseRunnable;
    private final CompletableFuture<ClientResponseTrailers> responseTrailers;
    private final InputStream inputStream;
    private final MediaContext mediaContext;
    private final ClientUri lastEndpointUri;
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private boolean entityRequested;

    Http2ClientResponseImpl(HttpClientConfig httpClientConfig, Status status, ClientRequestHeaders requestHeaders, ClientResponseHeaders responseHeaders, CompletableFuture<ClientResponseTrailers> responseTrailers, InputStream inputStream, MediaContext mediaContext, ClientUri lastEndpointUri, ReleasableResource stream, CompletableFuture<Void> complete, Runnable closeResponseRunnable) {
        this.httpClientConfig = httpClientConfig;
        this.responseStatus = status;
        this.requestHeaders = requestHeaders;
        this.responseHeaders = responseHeaders;
        this.responseTrailers = responseTrailers;
        this.inputStream = inputStream;
        this.mediaContext = mediaContext;
        this.lastEndpointUri = lastEndpointUri;
        this.stream = stream;
        this.complete = complete;
        this.closeResponseRunnable = closeResponseRunnable;
    }

    public Status status() {
        return this.responseStatus;
    }

    public ClientResponseHeaders headers() {
        return this.responseHeaders;
    }

    public ClientResponseTrailers trailers() {
        Duration timeout = this.httpClientConfig.readTimeout().orElseGet(() -> this.httpClientConfig.socketOptions().readTimeout());
        if (!this.entityRequested) {
            throw new IllegalStateException("Trailers requested before reading entity.");
        }
        try {
            return ClientResponseTrailers.create((Headers)((Headers)this.responseTrailers.get(timeout.toMillis(), TimeUnit.MILLISECONDS)));
        }
        catch (TimeoutException e) {
            throw new IllegalStateException("Timeout " + String.valueOf(timeout) + " reached while waiting for trailers.", e);
        }
        catch (InterruptedException e) {
            throw new IllegalStateException("Interrupted while waiting for trailers.", e);
        }
        catch (ExecutionException e) {
            Throwable throwable = e.getCause();
            if (throwable instanceof IllegalStateException) {
                IllegalStateException ise = (IllegalStateException)throwable;
                throw ise;
            }
            throw new IllegalStateException(e.getCause());
        }
    }

    public ReadableEntity entity() {
        this.entityRequested = true;
        if (this.inputStream == null) {
            return ClientResponseEntity.empty();
        }
        return ClientResponseEntity.create(this::readBytes, this::close, (ClientRequestHeaders)this.requestHeaders, (ClientResponseHeaders)this.responseHeaders, (MediaContext)this.mediaContext);
    }

    Http2ClientStream stream() {
        return (Http2ClientStream)this.stream;
    }

    private BufferData readBytes(int estimate) {
        try {
            byte[] buffer = new byte[estimate > 0 ? estimate : 16];
            int read = this.inputStream.read(buffer);
            if (read < 1) {
                return BufferData.empty();
            }
            return BufferData.create((byte[])buffer, (int)0, (int)read);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public ClientUri lastEndpointUri() {
        return this.lastEndpointUri;
    }

    public void close() {
        if (!this.closed.getAndSet(true)) {
            this.complete.complete(null);
            this.closeResponseRunnable.run();
        }
    }
}

