/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webclient.http2;

import io.helidon.http.ClientRequestHeaders;
import io.helidon.http.Method;
import io.helidon.webclient.api.ClientRequest;
import io.helidon.webclient.api.ClientRequestBase;
import io.helidon.webclient.api.ClientUri;
import io.helidon.webclient.api.FullClientRequest;
import io.helidon.webclient.api.HttpClientConfig;
import io.helidon.webclient.api.WebClientServiceRequest;
import io.helidon.webclient.api.WebClientServiceResponse;
import io.helidon.webclient.http2.Http2CallChainBase;
import io.helidon.webclient.http2.Http2CallEntityChain;
import io.helidon.webclient.http2.Http2CallOutputStreamChain;
import io.helidon.webclient.http2.Http2ClientImpl;
import io.helidon.webclient.http2.Http2ClientProtocolConfig;
import io.helidon.webclient.http2.Http2ClientRequest;
import io.helidon.webclient.http2.Http2ClientResponse;
import io.helidon.webclient.http2.Http2ClientResponseImpl;
import io.helidon.webclient.http2.Http2StreamConfig;
import io.helidon.webclient.http2.RedirectionProcessor;
import java.time.Duration;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

class Http2ClientRequestImpl
extends ClientRequestBase<Http2ClientRequest, Http2ClientResponse>
implements Http2ClientRequest,
Http2StreamConfig,
FullClientRequest<Http2ClientRequest> {
    private final Http2ClientImpl http2Client;
    private int priority = 16;
    private boolean priorKnowledge;
    private int requestPrefetch = 0;
    private Duration flowControlTimeout = Duration.ofMillis(100L);
    private boolean outputStreamRedirect = false;
    private final FullClientRequest<?> delegate;

    Http2ClientRequestImpl(Http2ClientImpl http2Client, FullClientRequest<?> delegate, Method method, ClientUri clientUri, Map<String, String> properties) {
        super((HttpClientConfig)http2Client.clientConfig(), http2Client.webClient().cookieManager(), "h2", method, clientUri, properties);
        this.http2Client = http2Client;
        Http2ClientProtocolConfig protocolConfig = http2Client.protocolConfig();
        this.priorKnowledge = protocolConfig.priorKnowledge();
        this.delegate = delegate;
    }

    Http2ClientRequestImpl(Http2ClientRequestImpl request, Method method, ClientUri clientUri, Map<String, String> properties) {
        this(request.http2Client, request.delegate, method, clientUri, properties);
        this.followRedirects(request.followRedirects());
        this.maxRedirects(request.maxRedirects());
        this.tls(request.tls());
        this.priority(request.priority);
        this.priorKnowledge(request.priorKnowledge);
        this.flowControlTimeout(request.flowControlTimeout);
        this.requestPrefetch(request.requestPrefetch);
        this.readTimeout(request.readTimeout());
        this.outputStreamRedirect(request.outputStreamRedirect);
    }

    @Override
    public Http2ClientRequest priority(int priority) {
        if (priority < 1 || priority > 256) {
            throw new IllegalArgumentException("Priority must be between 1 and 256 (inclusive), but is " + priority);
        }
        this.priority = priority;
        return this;
    }

    @Override
    public Http2ClientRequest priorKnowledge(boolean priorKnowledge) {
        this.priorKnowledge = priorKnowledge;
        return this;
    }

    @Override
    public Http2ClientRequest requestPrefetch(int requestPrefetch) {
        this.requestPrefetch = requestPrefetch;
        return this;
    }

    @Override
    public Http2ClientRequest flowControlTimeout(Duration timeout) {
        this.flowControlTimeout = timeout;
        return this;
    }

    public Http2ClientResponse doSubmit(Object entity) {
        if (this.followRedirects()) {
            return RedirectionProcessor.invokeWithFollowRedirects(this, 0, entity);
        }
        return this.invokeEntity(entity);
    }

    public Http2ClientResponse doOutputStream(ClientRequest.OutputStreamHandler streamHandler) {
        CompletableFuture<WebClientServiceRequest> whenSent = new CompletableFuture<WebClientServiceRequest>();
        CompletableFuture<WebClientServiceResponse> whenComplete = new CompletableFuture<WebClientServiceResponse>();
        Http2CallOutputStreamChain callChain = new Http2CallOutputStreamChain(this.http2Client, this, whenSent, whenComplete, streamHandler);
        return this.invokeWithServices(callChain, whenSent, whenComplete);
    }

    @Override
    public boolean priorKnowledge() {
        return this.priorKnowledge;
    }

    @Override
    public int priority() {
        return this.priority;
    }

    int requestPrefetch() {
        return this.requestPrefetch;
    }

    Duration flowControlTimeout() {
        return this.flowControlTimeout;
    }

    Http2ClientRequestImpl outputStreamRedirect(boolean outputStreamRedirect) {
        this.outputStreamRedirect = outputStreamRedirect;
        return this;
    }

    boolean outputStreamRedirect() {
        return this.outputStreamRedirect;
    }

    Http2ClientResponseImpl invokeEntity(Object entity) {
        CompletableFuture<WebClientServiceRequest> whenSent = new CompletableFuture<WebClientServiceRequest>();
        CompletableFuture<WebClientServiceResponse> whenComplete = new CompletableFuture<WebClientServiceResponse>();
        Http2CallEntityChain httpCall = new Http2CallEntityChain(this.http2Client, this, whenSent, whenComplete, entity);
        return this.invokeWithServices(httpCall, whenSent, whenComplete);
    }

    private Http2ClientResponseImpl invokeWithServices(Http2CallChainBase callChain, CompletableFuture<WebClientServiceRequest> whenSent, CompletableFuture<WebClientServiceResponse> whenComplete) {
        ClientUri resolvedUri = this.resolvedUri();
        WebClientServiceResponse serviceResponse = this.invokeServices(callChain, whenSent, whenComplete, resolvedUri);
        CompletableFuture<Void> complete = new CompletableFuture<Void>();
        ((CompletableFuture)complete.thenAccept(ignored -> serviceResponse.whenComplete().complete(serviceResponse))).exceptionally(throwable -> {
            serviceResponse.whenComplete().completeExceptionally((Throwable)throwable);
            return null;
        });
        if (this.delegate != null) {
            ClientRequestHeaders delegateHeaders = this.delegate.headers();
            this.headers().forEach(arg_0 -> ((ClientRequestHeaders)delegateHeaders).set(arg_0));
        }
        return new Http2ClientResponseImpl(this.clientConfig(), serviceResponse.status(), callChain.requestHeaders(), serviceResponse.headers(), serviceResponse.trailers(), serviceResponse.inputStream().orElse(null), this.mediaContext(), resolvedUri, serviceResponse.connection(), complete, callChain::closeResponse);
    }
}

