/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webclient.http2;

import io.helidon.http.http2.Http2FrameData;
import io.helidon.webclient.http2.Http2ClientStream;
import io.helidon.webclient.http2.StreamTimeoutException;
import java.time.Duration;
import java.util.ArrayDeque;
import java.util.Queue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

class StreamBuffer {
    private final Lock streamLock = new ReentrantLock();
    private final Semaphore dequeSemaphore = new Semaphore(1);
    private final Queue<Http2FrameData> buffer = new ArrayDeque<Http2FrameData>();
    private final Http2ClientStream stream;
    private final int streamId;

    StreamBuffer(Http2ClientStream stream, int streamId) {
        this.stream = stream;
        this.streamId = streamId;
    }

    Http2FrameData poll(Duration timeout) {
        try {
            if (!this.dequeSemaphore.tryAcquire(timeout.toMillis(), TimeUnit.MILLISECONDS)) {
                throw new StreamTimeoutException(this.stream, this.streamId, timeout);
            }
        }
        catch (InterruptedException e) {
            throw new IllegalStateException("Interrupted while waiting for data", e);
        }
        try {
            this.streamLock.lock();
            Http2FrameData http2FrameData = this.buffer.poll();
            return http2FrameData;
        }
        finally {
            this.streamLock.unlock();
        }
    }

    void push(Http2FrameData frameData) {
        try {
            this.streamLock.lock();
            this.buffer.add(frameData);
        }
        finally {
            this.streamLock.unlock();
            this.dequeSemaphore.release();
        }
    }
}

