/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webclient.http2;

import io.helidon.builder.api.Prototype;
import io.helidon.common.Generated;
import io.helidon.common.config.Config;
import io.helidon.webclient.http2.Http2ClientConfigSupport;
import io.helidon.webclient.http2.Http2ClientProtocolConfigBlueprint;
import java.time.Duration;
import java.util.Objects;
import java.util.Optional;

@Generated(value="io.helidon.builder.codegen.BuilderCodegen", trigger="io.helidon.webclient.http2.Http2ClientProtocolConfigBlueprint")
public interface Http2ClientProtocolConfig
extends Http2ClientProtocolConfigBlueprint,
Prototype.Api {
    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(Http2ClientProtocolConfig instance) {
        return (Builder)Http2ClientProtocolConfig.builder().from(instance);
    }

    public static Http2ClientProtocolConfig create(Config config) {
        return ((Builder)Http2ClientProtocolConfig.builder().config(config)).buildPrototype();
    }

    public static Http2ClientProtocolConfig create() {
        return Http2ClientProtocolConfig.builder().buildPrototype();
    }

    public static class Builder
    extends BuilderBase<Builder, Http2ClientProtocolConfig>
    implements io.helidon.common.Builder<Builder, Http2ClientProtocolConfig> {
        private Builder() {
        }

        public Http2ClientProtocolConfig buildPrototype() {
            this.preBuildPrototype();
            this.validatePrototype();
            return new BuilderBase.Http2ClientProtocolConfigImpl(this);
        }

        public Http2ClientProtocolConfig build() {
            return this.buildPrototype();
        }
    }

    public static abstract class BuilderBase<BUILDER extends BuilderBase<BUILDER, PROTOTYPE>, PROTOTYPE extends Http2ClientProtocolConfig>
    implements Prototype.ConfiguredBuilder<BUILDER, PROTOTYPE> {
        private boolean ping = false;
        private boolean priorKnowledge = false;
        private Config config;
        private Duration flowControlBlockTimeout = Duration.parse("PT15S");
        private Duration pingTimeout = Duration.parse("PT0.5S");
        private int initialWindowSize = 65535;
        private int maxFrameSize = 16384;
        private long maxHeaderListSize = -1L;
        private String name = "h2";

        protected BuilderBase() {
        }

        public BUILDER from(Http2ClientProtocolConfig prototype) {
            this.name(prototype.name());
            this.priorKnowledge(prototype.priorKnowledge());
            this.maxFrameSize(prototype.maxFrameSize());
            this.maxHeaderListSize(prototype.maxHeaderListSize());
            this.initialWindowSize(prototype.initialWindowSize());
            this.flowControlBlockTimeout(prototype.flowControlBlockTimeout());
            this.ping(prototype.ping());
            this.pingTimeout(prototype.pingTimeout());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER from(BuilderBase<?, ?> builder) {
            this.name(builder.name());
            this.priorKnowledge(builder.priorKnowledge());
            this.maxFrameSize(builder.maxFrameSize());
            this.maxHeaderListSize(builder.maxHeaderListSize());
            this.initialWindowSize(builder.initialWindowSize());
            this.flowControlBlockTimeout(builder.flowControlBlockTimeout());
            this.ping(builder.ping());
            this.pingTimeout(builder.pingTimeout());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER config(Config config) {
            Objects.requireNonNull(config);
            this.config = config;
            config.get("name").as(String.class).ifPresent(this::name);
            config.get("prior-knowledge").as(Boolean.class).ifPresent(this::priorKnowledge);
            config.get("max-frame-size").as(Integer.class).ifPresent(this::maxFrameSize);
            config.get("max-header-list-size").as(Long.class).ifPresent(this::maxHeaderListSize);
            config.get("initial-window-size").as(Integer.class).ifPresent(this::initialWindowSize);
            config.get("flow-control-block-timeout").as(Duration.class).ifPresent(this::flowControlBlockTimeout);
            config.get("ping").as(Boolean.class).ifPresent(this::ping);
            config.get("ping-timeout").as(Duration.class).ifPresent(this::pingTimeout);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER name(String name) {
            Objects.requireNonNull(name);
            this.name = name;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER priorKnowledge(boolean priorKnowledge) {
            this.priorKnowledge = priorKnowledge;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER maxFrameSize(int maxFrameSize) {
            this.maxFrameSize = maxFrameSize;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER maxHeaderListSize(long maxHeaderListSize) {
            this.maxHeaderListSize = maxHeaderListSize;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER initialWindowSize(int initialWindowSize) {
            this.initialWindowSize = initialWindowSize;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER flowControlBlockTimeout(Duration flowControlBlockTimeout) {
            Objects.requireNonNull(flowControlBlockTimeout);
            this.flowControlBlockTimeout = flowControlBlockTimeout;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER ping(boolean ping) {
            this.ping = ping;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER pingTimeout(Duration pingTimeout) {
            Objects.requireNonNull(pingTimeout);
            this.pingTimeout = pingTimeout;
            return (BUILDER)((BuilderBase)this.self());
        }

        public String name() {
            return this.name;
        }

        public boolean priorKnowledge() {
            return this.priorKnowledge;
        }

        public int maxFrameSize() {
            return this.maxFrameSize;
        }

        public long maxHeaderListSize() {
            return this.maxHeaderListSize;
        }

        public int initialWindowSize() {
            return this.initialWindowSize;
        }

        public Duration flowControlBlockTimeout() {
            return this.flowControlBlockTimeout;
        }

        public boolean ping() {
            return this.ping;
        }

        public Duration pingTimeout() {
            return this.pingTimeout;
        }

        public Optional<Config> config() {
            return Optional.ofNullable(this.config);
        }

        public String toString() {
            return "Http2ClientProtocolConfigBuilder{name=" + this.name + ",priorKnowledge=" + this.priorKnowledge + ",maxFrameSize=" + this.maxFrameSize + ",maxHeaderListSize=" + this.maxHeaderListSize + ",initialWindowSize=" + this.initialWindowSize + ",flowControlBlockTimeout=" + String.valueOf(this.flowControlBlockTimeout) + ",ping=" + this.ping + ",pingTimeout=" + String.valueOf(this.pingTimeout) + "}";
        }

        protected void preBuildPrototype() {
            new Http2ClientConfigSupport.ProtocolConfigDecorator().decorate(this);
        }

        protected void validatePrototype() {
        }

        protected static class Http2ClientProtocolConfigImpl
        implements Http2ClientProtocolConfig {
            private final boolean ping;
            private final boolean priorKnowledge;
            private final Duration flowControlBlockTimeout;
            private final Duration pingTimeout;
            private final int initialWindowSize;
            private final int maxFrameSize;
            private final long maxHeaderListSize;
            private final String name;

            protected Http2ClientProtocolConfigImpl(BuilderBase<?, ?> builder) {
                this.name = builder.name();
                this.priorKnowledge = builder.priorKnowledge();
                this.maxFrameSize = builder.maxFrameSize();
                this.maxHeaderListSize = builder.maxHeaderListSize();
                this.initialWindowSize = builder.initialWindowSize();
                this.flowControlBlockTimeout = builder.flowControlBlockTimeout();
                this.ping = builder.ping();
                this.pingTimeout = builder.pingTimeout();
            }

            @Override
            public String name() {
                return this.name;
            }

            @Override
            public boolean priorKnowledge() {
                return this.priorKnowledge;
            }

            @Override
            public int maxFrameSize() {
                return this.maxFrameSize;
            }

            @Override
            public long maxHeaderListSize() {
                return this.maxHeaderListSize;
            }

            @Override
            public int initialWindowSize() {
                return this.initialWindowSize;
            }

            @Override
            public Duration flowControlBlockTimeout() {
                return this.flowControlBlockTimeout;
            }

            @Override
            public boolean ping() {
                return this.ping;
            }

            @Override
            public Duration pingTimeout() {
                return this.pingTimeout;
            }

            public String toString() {
                return "Http2ClientProtocolConfig{name=" + this.name + ",priorKnowledge=" + this.priorKnowledge + ",maxFrameSize=" + this.maxFrameSize + ",maxHeaderListSize=" + this.maxHeaderListSize + ",initialWindowSize=" + this.initialWindowSize + ",flowControlBlockTimeout=" + String.valueOf(this.flowControlBlockTimeout) + ",ping=" + this.ping + ",pingTimeout=" + String.valueOf(this.pingTimeout) + "}";
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Http2ClientProtocolConfig)) {
                    return false;
                }
                Http2ClientProtocolConfig other = (Http2ClientProtocolConfig)o;
                return Objects.equals(this.name, other.name()) && this.priorKnowledge == other.priorKnowledge() && this.maxFrameSize == other.maxFrameSize() && this.maxHeaderListSize == other.maxHeaderListSize() && this.initialWindowSize == other.initialWindowSize() && Objects.equals(this.flowControlBlockTimeout, other.flowControlBlockTimeout()) && this.ping == other.ping() && Objects.equals(this.pingTimeout, other.pingTimeout());
            }

            public int hashCode() {
                return Objects.hash(this.name, this.priorKnowledge, this.maxFrameSize, this.maxHeaderListSize, this.initialWindowSize, this.flowControlBlockTimeout, this.ping, this.pingTimeout);
            }
        }
    }
}

