/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webclient.http2;

import io.helidon.common.configurable.LruCache;
import io.helidon.common.configurable.LruCacheConfig;
import io.helidon.webclient.api.ClientUri;
import io.helidon.webclient.api.ConnectionKey;
import io.helidon.webclient.http1.Http1ClientRequest;
import io.helidon.webclient.http1.Http1ClientResponse;
import io.helidon.webclient.http2.Http2ClientConnectionHandler;
import io.helidon.webclient.http2.Http2ClientImpl;
import io.helidon.webclient.http2.Http2ClientRequestImpl;
import io.helidon.webclient.http2.Http2ConnectionAttemptResult;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;

final class Http2ConnectionCache {
    private static final Http2ConnectionCache SHARED = Http2ConnectionCache.create();
    private final LruCache<ConnectionKey, Boolean> http2Supported = ((LruCacheConfig.Builder)LruCache.builder().capacity(1000)).build();
    private final Map<ConnectionKey, Http2ClientConnectionHandler> cache = new ConcurrentHashMap<ConnectionKey, Http2ClientConnectionHandler>();

    Http2ConnectionCache() {
    }

    static Http2ConnectionCache shared() {
        return SHARED;
    }

    static Http2ConnectionCache create() {
        return new Http2ConnectionCache();
    }

    boolean supports(ConnectionKey ck) {
        return this.http2Supported.get((Object)ck).isPresent();
    }

    void remove(ConnectionKey connectionKey) {
        Http2ClientConnectionHandler handler = this.cache.remove(connectionKey);
        if (handler != null) {
            handler.close();
        }
        this.http2Supported.remove((Object)connectionKey);
    }

    Http2ConnectionAttemptResult newStream(Http2ClientImpl http2Client, ConnectionKey connectionKey, Http2ClientRequestImpl request, ClientUri initialUri, Function<Http1ClientRequest, Http1ClientResponse> http1EntityHandler) {
        Http2ConnectionAttemptResult result = this.cache.computeIfAbsent(connectionKey, Http2ClientConnectionHandler::new).newStream(http2Client, request, initialUri, http1EntityHandler);
        if (result.result() == Http2ConnectionAttemptResult.Result.HTTP_2) {
            this.http2Supported.put((Object)connectionKey, (Object)true);
        }
        return result;
    }
}

