/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webclient.http2;

import io.helidon.common.buffers.BufferData;
import io.helidon.common.tls.Tls;
import io.helidon.common.tls.TlsConfig;
import io.helidon.http.ClientRequestHeaders;
import io.helidon.http.ClientResponseHeaders;
import io.helidon.http.Headers;
import io.helidon.http.Http;
import io.helidon.http.WritableHeaders;
import io.helidon.http.encoding.ContentDecoder;
import io.helidon.http.encoding.ContentEncodingContext;
import io.helidon.http.http2.Http2Headers;
import io.helidon.webclient.api.ClientRequestBase;
import io.helidon.webclient.api.ClientUri;
import io.helidon.webclient.api.ConnectionKey;
import io.helidon.webclient.api.HttpClientConfig;
import io.helidon.webclient.api.HttpClientResponse;
import io.helidon.webclient.api.ReleasableResource;
import io.helidon.webclient.api.WebClientServiceRequest;
import io.helidon.webclient.api.WebClientServiceResponse;
import io.helidon.webclient.http1.Http1ClientRequest;
import io.helidon.webclient.http1.Http1ClientResponse;
import io.helidon.webclient.http2.Http2ClientImpl;
import io.helidon.webclient.http2.Http2ClientRequestImpl;
import io.helidon.webclient.http2.Http2ClientStream;
import io.helidon.webclient.http2.Http2ConnectionAttemptResult;
import io.helidon.webclient.http2.StreamTimeoutException;
import io.helidon.webclient.spi.WebClientService;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;

abstract class Http2CallChainBase
implements WebClientService.Chain {
    private static final Tls NO_TLS = ((TlsConfig.Builder)Tls.builder().enabled(false)).build();
    private final Http2ClientImpl http2Client;
    private final HttpClientConfig clientConfig;
    private final Http2ClientRequestImpl clientRequest;
    private final Function<Http1ClientRequest, Http1ClientResponse> http1EntityHandler;
    private final CompletableFuture<WebClientServiceResponse> whenComplete;
    private Http2ClientStream stream;
    private HttpClientResponse response;
    private ClientRequestHeaders requestHeaders;
    private Http.Status responseStatus;

    Http2CallChainBase(Http2ClientImpl http2Client, Http2ClientRequestImpl clientRequest, CompletableFuture<WebClientServiceResponse> whenComplete, Function<Http1ClientRequest, Http1ClientResponse> http1EntityHandler) {
        this.http2Client = http2Client;
        this.clientConfig = http2Client.clientConfig();
        this.clientRequest = clientRequest;
        this.whenComplete = whenComplete;
        this.http1EntityHandler = http1EntityHandler;
    }

    public WebClientServiceResponse proceed(WebClientServiceRequest serviceRequest) {
        ClientUri uri = serviceRequest.uri();
        this.requestHeaders = serviceRequest.headers();
        this.requestHeaders.setIfAbsent(Http.Headers.create((Http.HeaderName)Http.HeaderNames.HOST, (String)uri.authority()));
        this.requestHeaders.remove(Http.HeaderNames.CONNECTION, (Consumer)LogHeaderConsumer.INSTANCE);
        this.requestHeaders.setIfAbsent(ClientRequestBase.USER_AGENT_HEADER);
        ConnectionKey connectionKey = this.connectionKey(serviceRequest);
        Http2ConnectionAttemptResult result = this.http2Client.connectionCache().newStream(this.http2Client, connectionKey, this.clientRequest, uri, this.http1EntityHandler);
        try {
            if (result.result() == Http2ConnectionAttemptResult.Result.HTTP_2) {
                this.stream = result.stream();
                return this.doProceed(serviceRequest, this.requestHeaders, result.stream());
            }
            this.response = result.response();
            return this.doProceed(serviceRequest, result.response());
        }
        catch (StreamTimeoutException e) {
            this.http2Client.connectionCache().remove(connectionKey);
            throw e;
        }
    }

    ClientRequestHeaders requestHeaders() {
        return this.requestHeaders;
    }

    Http.Status responseStatus() {
        return this.responseStatus;
    }

    protected abstract WebClientServiceResponse doProceed(WebClientServiceRequest var1, ClientRequestHeaders var2, Http2ClientStream var3);

    protected WebClientServiceResponse doProceed(WebClientServiceRequest serviceRequest, HttpClientResponse response) {
        this.responseStatus = response.status();
        WebClientServiceResponse.Builder builder = WebClientServiceResponse.builder();
        if (response.entity().hasEntity()) {
            builder.inputStream(response.inputStream());
        }
        return ((WebClientServiceResponse.Builder)((WebClientServiceResponse.Builder)((WebClientServiceResponse.Builder)((WebClientServiceResponse.Builder)((WebClientServiceResponse.Builder)builder.serviceRequest(serviceRequest)).whenComplete(this.whenComplete)).status(response.status())).headers(response.headers())).connection((ReleasableResource)new Http1ResponseResource(response))).build();
    }

    protected WebClientServiceResponse readResponse(WebClientServiceRequest serviceRequest, Http2ClientStream stream) {
        Http2Headers headers = stream.readHeaders();
        ClientResponseHeaders responseHeaders = ClientResponseHeaders.create((Headers)headers.httpHeaders());
        this.responseStatus = headers.status();
        WebClientServiceResponse.Builder builder = WebClientServiceResponse.builder();
        AtomicReference<WebClientServiceResponse> response = new AtomicReference<WebClientServiceResponse>();
        if (stream.hasEntity()) {
            ContentDecoder decoder = this.contentDecoder(responseHeaders);
            builder.inputStream(decoder.apply((InputStream)new RequestingInputStream(stream, this.whenComplete, response)));
        }
        WebClientServiceResponse serviceResponse = ((WebClientServiceResponse.Builder)((WebClientServiceResponse.Builder)((WebClientServiceResponse.Builder)((WebClientServiceResponse.Builder)((WebClientServiceResponse.Builder)builder.serviceRequest(serviceRequest)).whenComplete(this.whenComplete)).status(this.responseStatus)).headers(responseHeaders)).connection((ReleasableResource)stream)).build();
        response.set(serviceResponse);
        return serviceResponse;
    }

    private ContentDecoder contentDecoder(ClientResponseHeaders responseHeaders) {
        ContentEncodingContext encodingSupport = this.clientConfig.contentEncoding();
        if (encodingSupport.contentDecodingEnabled() && responseHeaders.contains(Http.HeaderNames.CONTENT_ENCODING)) {
            String contentEncoding = responseHeaders.get(Http.HeaderNames.CONTENT_ENCODING).value();
            if (encodingSupport.contentDecodingSupported(contentEncoding)) {
                return encodingSupport.decoder(contentEncoding);
            }
            throw new IllegalStateException("Unsupported content encoding: \n" + BufferData.create((byte[])contentEncoding.getBytes(StandardCharsets.UTF_8)).debugDataHex());
        }
        return ContentDecoder.NO_OP;
    }

    protected Http2Headers prepareHeaders(Http.Method method, ClientRequestHeaders headers, ClientUri uri) {
        Http2Headers h2Headers = Http2Headers.create((WritableHeaders)headers);
        h2Headers.method(method);
        h2Headers.path(uri.pathWithQueryAndFragment());
        h2Headers.scheme(uri.scheme());
        return h2Headers;
    }

    protected HttpClientConfig clientConfig() {
        return this.clientConfig;
    }

    protected Http2ClientRequestImpl clientRequest() {
        return this.clientRequest;
    }

    void closeResponse() {
        if (this.response != null) {
            this.response.close();
        }
        if (this.stream != null) {
            try {
                this.stream.cancel();
            }
            finally {
                this.stream.close();
            }
        }
    }

    private ConnectionKey connectionKey(WebClientServiceRequest serviceRequest) {
        ClientUri uri = serviceRequest.uri();
        return new ConnectionKey(uri.scheme(), uri.host(), uri.port(), "https".equals(uri.scheme()) ? this.clientRequest.tls() : NO_TLS, this.clientConfig.dnsResolver(), this.clientConfig.dnsAddressLookup(), this.clientRequest.proxy());
    }

    private static final class LogHeaderConsumer
    implements Consumer<Http.Header> {
        private static final System.Logger LOGGER = System.getLogger(LogHeaderConsumer.class.getName());
        private static final LogHeaderConsumer INSTANCE = new LogHeaderConsumer();

        private LogHeaderConsumer() {
        }

        @Override
        public void accept(Http.Header httpHeader) {
            if (LOGGER.isLoggable(System.Logger.Level.DEBUG)) {
                LOGGER.log(System.Logger.Level.DEBUG, "HTTP/2 request contains wrong header, removing {0}", httpHeader);
            }
        }
    }

    protected static class Http1ResponseResource
    implements ReleasableResource {
        private final HttpClientResponse response;

        Http1ResponseResource(HttpClientResponse response) {
            this.response = response;
        }

        public void closeResource() {
            this.response.close();
        }
    }

    private static class RequestingInputStream
    extends InputStream {
        private final Function<Integer, BufferData> bufferFunction = stream::read;
        private final Runnable entityProcessedRunnable = () -> whenComplete.complete((WebClientServiceResponse)response.get());
        private BufferData currentBuffer;
        private boolean finished;

        RequestingInputStream(Http2ClientStream stream, CompletableFuture<WebClientServiceResponse> whenComplete, AtomicReference<WebClientServiceResponse> response) {
        }

        @Override
        public int read() {
            if (this.finished) {
                return -1;
            }
            this.ensureBuffer(512);
            if (this.finished || this.currentBuffer == null) {
                return -1;
            }
            return this.currentBuffer.read();
        }

        @Override
        public int read(byte[] b, int off, int len) {
            if (this.finished) {
                return -1;
            }
            this.ensureBuffer(len);
            if (this.finished || this.currentBuffer == null) {
                return -1;
            }
            return this.currentBuffer.read(b, off, len);
        }

        private void ensureBuffer(int estimate) {
            if (this.currentBuffer != null && this.currentBuffer.consumed()) {
                this.currentBuffer = null;
            }
            if (this.currentBuffer == null) {
                this.currentBuffer = this.bufferFunction.apply(estimate);
                if (this.currentBuffer == null || this.currentBuffer == BufferData.empty()) {
                    this.entityProcessedRunnable.run();
                    this.finished = true;
                }
            }
        }
    }
}

