/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webclient.http1;

import io.helidon.common.buffers.BufferData;
import io.helidon.common.buffers.DataReader;
import io.helidon.common.buffers.DataWriter;
import io.helidon.common.media.type.ParserMode;
import io.helidon.common.socket.HelidonSocket;
import io.helidon.common.tls.Tls;
import io.helidon.http.ClientRequestHeaders;
import io.helidon.http.ClientResponseHeaders;
import io.helidon.http.Header;
import io.helidon.http.HeaderName;
import io.helidon.http.HeaderNames;
import io.helidon.http.HeaderValues;
import io.helidon.http.Headers;
import io.helidon.http.Http1HeadersParser;
import io.helidon.http.Method;
import io.helidon.http.Status;
import io.helidon.http.WritableHeaders;
import io.helidon.http.encoding.ContentDecoder;
import io.helidon.http.encoding.ContentEncodingContext;
import io.helidon.webclient.api.ClientConnection;
import io.helidon.webclient.api.ClientUri;
import io.helidon.webclient.api.HttpClientConfig;
import io.helidon.webclient.api.Proxy;
import io.helidon.webclient.api.ReleasableResource;
import io.helidon.webclient.api.WebClientServiceRequest;
import io.helidon.webclient.api.WebClientServiceResponse;
import io.helidon.webclient.http1.Http1ClientImpl;
import io.helidon.webclient.http1.Http1ClientProtocolConfig;
import io.helidon.webclient.http1.Http1ClientRequestImpl;
import io.helidon.webclient.http1.Http1StatusParser;
import io.helidon.webclient.spi.WebClientService;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.InetSocketAddress;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;

abstract class Http1CallChainBase
implements WebClientService.Chain {
    private static final System.Logger LOGGER = System.getLogger(Http1CallChainBase.class.getName());
    private final BufferData writeBuffer = BufferData.growing((int)128);
    private final HttpClientConfig clientConfig;
    private final Http1ClientProtocolConfig protocolConfig;
    private final ClientConnection connection;
    private final Http1ClientRequestImpl originalRequest;
    private final Tls tls;
    private final Proxy proxy;
    private final boolean keepAlive;
    private final CompletableFuture<WebClientServiceResponse> whenComplete;
    private final Duration timeout;
    private final Http1ClientImpl http1Client;
    private ClientConnection effectiveConnection;

    Http1CallChainBase(Http1ClientImpl http1Client, Http1ClientRequestImpl clientRequest, CompletableFuture<WebClientServiceResponse> whenComplete) {
        this.clientConfig = http1Client.clientConfig();
        this.protocolConfig = http1Client.protocolConfig();
        this.originalRequest = clientRequest;
        this.timeout = clientRequest.readTimeout();
        this.connection = clientRequest.connection().orElse(null);
        this.tls = clientRequest.tls();
        this.proxy = clientRequest.proxy();
        this.keepAlive = clientRequest.keepAlive();
        this.http1Client = clientRequest.http1Client();
        this.whenComplete = whenComplete;
    }

    static void writeHeaders(Headers headers, BufferData bufferData, boolean validate) {
        for (Header header : headers) {
            if (validate) {
                header.validate();
            }
            header.writeHttp1Header(bufferData);
        }
        bufferData.write(13);
        bufferData.write(10);
    }

    static WebClientServiceResponse createServiceResponse(HttpClientConfig clientConfig, WebClientServiceRequest serviceRequest, ClientConnection connection, DataReader reader, Status responseStatus, ClientResponseHeaders responseHeaders, CompletableFuture<WebClientServiceResponse> whenComplete) {
        WebClientServiceResponse.Builder builder = WebClientServiceResponse.builder();
        AtomicReference<WebClientServiceResponse> response = new AtomicReference<WebClientServiceResponse>();
        if (Http1CallChainBase.mayHaveEntity(responseStatus, responseHeaders)) {
            builder.inputStream(Http1CallChainBase.inputStream(clientConfig, connection.helidonSocket(), response, responseHeaders, reader, whenComplete));
        }
        WebClientServiceResponse serviceResponse = ((WebClientServiceResponse.Builder)((WebClientServiceResponse.Builder)((WebClientServiceResponse.Builder)((WebClientServiceResponse.Builder)((WebClientServiceResponse.Builder)builder.connection((ReleasableResource)connection)).headers(responseHeaders)).status(responseStatus)).whenComplete(whenComplete)).serviceRequest(serviceRequest)).build();
        response.set(serviceResponse);
        return serviceResponse;
    }

    public WebClientServiceResponse proceed(WebClientServiceRequest serviceRequest) {
        this.effectiveConnection = this.connection == null ? this.obtainConnection(serviceRequest) : this.connection;
        this.effectiveConnection.readTimeout(this.timeout);
        DataWriter writer = this.effectiveConnection.writer();
        DataReader reader = this.effectiveConnection.reader();
        ClientUri uri = serviceRequest.uri();
        ClientRequestHeaders headers = serviceRequest.headers();
        this.writeBuffer.clear();
        this.prologue(this.writeBuffer, serviceRequest, uri);
        headers.setIfAbsent(HeaderValues.create((HeaderName)HeaderNames.HOST, (String)uri.authority()));
        return this.doProceed(this.effectiveConnection, serviceRequest, headers, writer, reader, this.writeBuffer);
    }

    abstract WebClientServiceResponse doProceed(ClientConnection var1, WebClientServiceRequest var2, ClientRequestHeaders var3, DataWriter var4, DataReader var5, BufferData var6);

    void prologue(BufferData nonEntityData, WebClientServiceRequest request, ClientUri uri) {
        if (request.method() == Method.CONNECT) {
            nonEntityData.writeAscii(request.method().text() + " " + request.headers().get(HeaderNames.HOST).value() + " HTTP/1.1\r\n");
        } else {
            String absoluteUri = uri.scheme() + "://" + uri.host() + ":" + uri.port();
            InetSocketAddress uriAddress = new InetSocketAddress(uri.host(), uri.port());
            String requestUri = this.proxy == Proxy.noProxy() || this.proxy.type() == Proxy.ProxyType.HTTP && this.proxy.isNoHosts(uriAddress) || this.proxy.type() == Proxy.ProxyType.SYSTEM && !this.proxy.isUsingSystemProxy(absoluteUri) || this.clientConfig.relativeUris() ? "" : absoluteUri;
            nonEntityData.writeAscii(request.method().text() + " " + requestUri + uri.pathWithQueryAndFragment() + " HTTP/1.1\r\n");
        }
    }

    ClientResponseHeaders readHeaders(DataReader reader) {
        WritableHeaders writable = Http1HeadersParser.readHeaders((DataReader)reader, (int)this.protocolConfig.maxHeaderSize(), (boolean)this.protocolConfig.validateResponseHeaders());
        return ClientResponseHeaders.create((Headers)writable, (ParserMode)this.clientConfig.mediaTypeParserMode());
    }

    HttpClientConfig clientConfig() {
        return this.clientConfig;
    }

    Http1ClientProtocolConfig protocolConfig() {
        return this.protocolConfig;
    }

    ClientConnection connection() {
        return this.effectiveConnection;
    }

    Http1ClientRequestImpl originalRequest() {
        return this.originalRequest;
    }

    CompletableFuture<WebClientServiceResponse> whenComplete() {
        return this.whenComplete;
    }

    protected WebClientServiceResponse readResponse(WebClientServiceRequest serviceRequest, ClientConnection connection, DataReader reader) {
        Status responseStatus;
        try {
            responseStatus = Http1StatusParser.readStatus(reader, this.protocolConfig.maxStatusLineLength());
        }
        catch (UncheckedIOException e) {
            try {
                connection.closeResource();
            }
            catch (Exception ex) {
                e.addSuppressed(ex);
            }
            throw e;
        }
        connection.helidonSocket().log(LOGGER, System.Logger.Level.TRACE, "client received status %n%s", new Object[]{responseStatus});
        ClientResponseHeaders responseHeaders = this.readHeaders(reader);
        connection.helidonSocket().log(LOGGER, System.Logger.Level.TRACE, "client received headers %n%s", new Object[]{responseHeaders});
        return Http1CallChainBase.createServiceResponse(this.clientConfig, serviceRequest, connection, reader, responseStatus, responseHeaders, this.whenComplete);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static InputStream inputStream(HttpClientConfig clientConfig, HelidonSocket helidonSocket, AtomicReference<WebClientServiceResponse> response, ClientResponseHeaders responseHeaders, DataReader reader, CompletableFuture<WebClientServiceResponse> whenComplete) {
        ContentDecoder decoder;
        ContentEncodingContext encodingSupport = clientConfig.contentEncoding();
        if (encodingSupport.contentDecodingEnabled() && responseHeaders.contains(HeaderNames.CONTENT_ENCODING)) {
            String contentEncoding = responseHeaders.get(HeaderNames.CONTENT_ENCODING).value();
            if (!encodingSupport.contentDecodingSupported(contentEncoding)) throw new IllegalStateException("Unsupported content encoding: \n" + BufferData.create((byte[])contentEncoding.getBytes(StandardCharsets.UTF_8)).debugDataHex());
            decoder = encodingSupport.decoder(contentEncoding);
        } else {
            decoder = ContentDecoder.NO_OP;
        }
        if (responseHeaders.contains(HeaderNames.CONTENT_LENGTH)) {
            long length = responseHeaders.contentLength().getAsLong();
            return decoder.apply((InputStream)new ContentLengthInputStream(helidonSocket, reader, whenComplete, response, length));
        }
        if (!responseHeaders.contains(HeaderValues.TRANSFER_ENCODING_CHUNKED)) return new EverythingInputStream(helidonSocket, reader, whenComplete, response);
        return new ChunkedInputStream(helidonSocket, reader, whenComplete, response);
    }

    private static boolean mayHaveEntity(Status responseStatus, ClientResponseHeaders responseHeaders) {
        if (responseHeaders.contains(HeaderValues.CONTENT_LENGTH_ZERO)) {
            return false;
        }
        if (responseStatus == Status.NO_CONTENT_204) {
            return false;
        }
        return !responseHeaders.contains(HeaderNames.UPGRADE) || responseHeaders.contains(HeaderValues.TRANSFER_ENCODING_CHUNKED);
    }

    private ClientConnection obtainConnection(WebClientServiceRequest request) {
        return this.http1Client.connectionCache().connection(this.http1Client, this.tls, this.proxy, request.uri(), request.headers(), this.keepAlive);
    }

    static class ContentLengthInputStream
    extends InputStream {
        private final DataReader reader;
        private final long length;
        private final Runnable entityProcessedRunnable;
        private final HelidonSocket socket;
        private BufferData currentBuffer;
        private boolean finished;
        private long remainingLength;

        ContentLengthInputStream(HelidonSocket socket, DataReader reader, CompletableFuture<WebClientServiceResponse> whenComplete, AtomicReference<WebClientServiceResponse> response, long length) {
            this.socket = socket;
            this.reader = reader;
            this.length = length;
            this.remainingLength = length;
            this.entityProcessedRunnable = () -> whenComplete.complete((WebClientServiceResponse)response.get());
        }

        @Override
        public int read() {
            if (this.finished) {
                return -1;
            }
            int maxRemaining = this.maxRemaining(512);
            this.ensureBuffer(maxRemaining);
            if (this.finished || this.currentBuffer == null) {
                return -1;
            }
            int read = this.currentBuffer.read();
            if (read != -1) {
                --this.remainingLength;
            }
            return read;
        }

        @Override
        public int read(byte[] b, int off, int len) {
            if (this.finished) {
                return -1;
            }
            int maxRemaining = this.maxRemaining(len);
            this.ensureBuffer(maxRemaining);
            if (this.finished || this.currentBuffer == null) {
                return -1;
            }
            int read = this.currentBuffer.read(b, off, len);
            this.remainingLength -= (long)read;
            return read;
        }

        private int maxRemaining(int estimate) {
            return Integer.min(estimate, (int)Long.min(Integer.MAX_VALUE, this.remainingLength));
        }

        private void ensureBuffer(int estimate) {
            if (this.remainingLength == 0L) {
                this.entityProcessedRunnable.run();
                this.finished = true;
                this.currentBuffer = null;
                return;
            }
            if (this.currentBuffer != null && !this.currentBuffer.consumed()) {
                return;
            }
            this.reader.ensureAvailable();
            int toRead = Math.min(this.reader.available(), estimate);
            this.currentBuffer = this.reader.readBuffer(toRead);
            if (this.currentBuffer == null || this.currentBuffer == BufferData.empty()) {
                this.entityProcessedRunnable.run();
                this.finished = true;
            } else {
                this.socket.log(LOGGER, System.Logger.Level.TRACE, "client read entity buffer %n%s", new Object[]{this.currentBuffer.debugDataHex(true)});
            }
        }
    }

    static class ChunkedInputStream
    extends InputStream {
        private final HelidonSocket helidonSocket;
        private final DataReader reader;
        private final Runnable entityProcessedRunnable;
        private BufferData currentBuffer;
        private boolean finished;

        ChunkedInputStream(HelidonSocket helidonSocket, DataReader reader, CompletableFuture<WebClientServiceResponse> whenComplete, AtomicReference<WebClientServiceResponse> response) {
            this.helidonSocket = helidonSocket;
            this.reader = reader;
            this.entityProcessedRunnable = () -> whenComplete.complete((WebClientServiceResponse)response.get());
        }

        @Override
        public int read() {
            if (this.finished) {
                return -1;
            }
            this.ensureBuffer();
            if (this.finished || this.currentBuffer == null) {
                return -1;
            }
            return this.currentBuffer.read();
        }

        @Override
        public int read(byte[] b, int off, int len) {
            if (this.finished) {
                return -1;
            }
            this.ensureBuffer();
            if (this.finished || this.currentBuffer == null) {
                return -1;
            }
            return this.currentBuffer.read(b, off, len);
        }

        private void ensureBuffer() {
            int length;
            if (this.currentBuffer != null && this.currentBuffer.available() > 0) {
                return;
            }
            int endOfChunkSize = this.reader.findNewLine(256);
            if (endOfChunkSize == 256) {
                this.entityProcessedRunnable.run();
                throw new IllegalStateException("Cannot read chunked entity, end of line not found within 256 bytes:\n" + String.valueOf(this.reader.readBuffer(Math.min(this.reader.available(), 256))));
            }
            String hex = this.reader.readAsciiString(endOfChunkSize);
            this.reader.skip(2);
            try {
                length = Integer.parseUnsignedInt(hex, 16);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Chunk size is not a number:\n" + BufferData.create((byte[])hex.getBytes(StandardCharsets.US_ASCII)).debugDataHex());
            }
            if (length == 0) {
                if (this.reader.startsWithNewLine()) {
                    this.reader.skip(2);
                }
                this.helidonSocket.log(LOGGER, System.Logger.Level.TRACE, "read last (empty) chunk", new Object[0]);
                this.finished = true;
                this.currentBuffer = null;
                this.entityProcessedRunnable.run();
                return;
            }
            BufferData chunk = this.reader.readBuffer(length);
            if (LOGGER.isLoggable(System.Logger.Level.TRACE)) {
                this.helidonSocket.log(LOGGER, System.Logger.Level.TRACE, "client read chunk %s", new Object[]{chunk.debugDataHex(true)});
            }
            this.reader.skip(2);
            this.currentBuffer = chunk;
        }
    }

    static class EverythingInputStream
    extends InputStream {
        private final HelidonSocket helidonSocket;
        private final DataReader reader;
        private final Runnable entityProcessedRunnable;
        private BufferData currentBuffer;
        private boolean finished;

        EverythingInputStream(HelidonSocket helidonSocket, DataReader reader, CompletableFuture<WebClientServiceResponse> whenComplete, AtomicReference<WebClientServiceResponse> response) {
            this.helidonSocket = helidonSocket;
            this.reader = reader;
            this.entityProcessedRunnable = () -> whenComplete.complete((WebClientServiceResponse)response.get());
        }

        @Override
        public int read() {
            if (this.finished) {
                return -1;
            }
            this.ensureBuffer(512);
            if (this.finished || this.currentBuffer == null) {
                return -1;
            }
            return this.currentBuffer.read();
        }

        @Override
        public int read(byte[] b, int off, int len) {
            if (this.finished) {
                return -1;
            }
            this.ensureBuffer(len);
            if (this.finished || this.currentBuffer == null) {
                return -1;
            }
            return this.currentBuffer.read(b, off, len);
        }

        private void ensureBuffer(int estimate) {
            if (this.currentBuffer != null && this.currentBuffer.available() > 0) {
                return;
            }
            this.reader.ensureAvailable();
            int toRead = Math.min(this.reader.available(), estimate);
            this.currentBuffer = this.reader.readBuffer(toRead);
            if (this.currentBuffer == null || this.currentBuffer == BufferData.empty()) {
                this.entityProcessedRunnable.run();
                this.finished = true;
            } else {
                this.helidonSocket.log(LOGGER, System.Logger.Level.TRACE, "client read entity buffer %n%s", new Object[]{this.currentBuffer.debugDataHex(true)});
            }
        }
    }
}

