// This is a generated file (powered by Helidon). Do not edit or extend from this artifact as it is subject to change at any time!

package io.helidon.webclient.http1;

import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;

import io.helidon.builder.api.Prototype;
import io.helidon.common.Generated;
import io.helidon.webclient.api.HttpClientConfig;

/**
 * HTTP/1.1. full webclient configuration.
 *
 * @see #builder()
 * @see #create()
 */
@Generated(value = "io.helidon.builder.processor.BlueprintProcessor", trigger = "io.helidon.webclient.http1.Http1ClientConfigBlueprint")
public interface Http1ClientConfig extends Http1ClientConfigBlueprint, Prototype.Api, HttpClientConfig {

    /**
     * Create a new fluent API builder to customize configuration.
     *
     * @return a new builder
     */
    static Http1ClientConfig.Builder builder() {
        return new Http1ClientConfig.Builder();
    }

    /**
     * Create a new fluent API builder from an existing instance.
     *
     * @param instance an existing instance used as a base for the builder
     * @return a builder based on an instance
     */
    static Http1ClientConfig.Builder builder(Http1ClientConfig instance) {
        return Http1ClientConfig.builder().from(instance);
    }

    /**
     * Create a new instance with default values.
     *
     * @return a new instance
     */
    static Http1ClientConfig create() {
        return Http1ClientConfig.builder().buildPrototype();
    }

    /**
     * Fluent API builder base for {@link Http1Client}.
     *
     * @param <BUILDER> type of the builder extending this abstract builder
     * @param <PROTOTYPE> type of the prototype interface that would be built by {@link #buildPrototype()}
     */
    abstract class BuilderBase<BUILDER extends Http1ClientConfig.BuilderBase<BUILDER, PROTOTYPE>, PROTOTYPE extends Http1ClientConfig> extends HttpClientConfig.BuilderBase<BUILDER, PROTOTYPE> implements Prototype.Builder<BUILDER, PROTOTYPE> {

        private Http1ClientProtocolConfig protocolConfig = Http1ClientProtocolConfig.create();

        /**
         * Protected to support extensibility.
         */
        protected BuilderBase() {
        }

        /**
         * Update this builder from an existing prototype instance.
         *
         * @param prototype existing prototype to update this builder from
         * @return updated builder instance
         */
        public BUILDER from(Http1ClientConfig prototype) {
            super.from(prototype);
            protocolConfig(prototype.protocolConfig());
            return self();
        }

        /**
         * Update this builder from an existing prototype builder instance.
         *
         * @param builder existing builder prototype to update this builder from
         * @return updated builder instance
         */
        public BUILDER from(Http1ClientConfig.BuilderBase<?, ?> builder) {
            super.from(builder);
            protocolConfig(builder.protocolConfig());
            return self();
        }

        /**
         * HTTP/1.1 specific configuration.
         *
         * @param protocolConfig protocol specific configuration
         * @return updated builder instance
         * @see #protocolConfig()
         */
        public BUILDER protocolConfig(Http1ClientProtocolConfig protocolConfig) {
            Objects.requireNonNull(protocolConfig);
            this.protocolConfig = protocolConfig;
            return self();
        }

        /**
         * HTTP/1.1 specific configuration.
         *
         * @param consumer consumer of builder for
         *                 protocol specific configuration
         * @return updated builder instance
         * @see #protocolConfig()
         */
        public BUILDER protocolConfig(Consumer<Http1ClientProtocolConfig.Builder> consumer) {
            Objects.requireNonNull(consumer);
            var builder = Http1ClientProtocolConfig.builder();
            consumer.accept(builder);
            this.protocolConfig(builder.build());
            return self();
        }

        /**
         * HTTP/1.1 specific configuration.
         *
         * @param supplier supplier of
         *                 protocol specific configuration
         * @return updated builder instance
         * @see #protocolConfig()
         */
        public BUILDER protocolConfig(Supplier<? extends Http1ClientProtocolConfig> supplier) {
            Objects.requireNonNull(supplier);
            this.protocolConfig(supplier.get());
            return self();
        }

        /**
         * HTTP/1.1 specific configuration.
         *
         * @return the protocol config
         */
        public Http1ClientProtocolConfig protocolConfig() {
            return protocolConfig;
        }

        @Override
        public String toString() {
            return "Http1ClientConfigBuilder{"
                    + "protocolConfig=" + protocolConfig
                    + "};"
                    + super.toString();
        }

        /**
         * Handles providers and decorators.
         */
        protected void preBuildPrototype() {
            super.preBuildPrototype();
        }

        /**
         * Validates required properties.
         */
        protected void validatePrototype() {
            super.validatePrototype();
        }

        /**
         * Generated implementation of the prototype, can be extended by descendant prototype implementations.
         */
        protected static class Http1ClientConfigImpl extends HttpClientConfigImpl implements Http1ClientConfig, Supplier<Http1Client> {

            private final Http1ClientProtocolConfig protocolConfig;

            /**
             * Create an instance providing a builder.
             *
             * @param builder extending builder base of this prototype
             */
            protected Http1ClientConfigImpl(Http1ClientConfig.BuilderBase<?, ?> builder) {
                super(builder);
                this.protocolConfig = builder.protocolConfig();
            }

            @Override
            public Http1Client build() {
                return Http1Client.create(this);
            }

            @Override
            public Http1Client get() {
                return build();
            }

            @Override
            public Http1ClientProtocolConfig protocolConfig() {
                return protocolConfig;
            }

            @Override
            public String toString() {
                return "Http1ClientConfig{"
                        + "protocolConfig=" + protocolConfig
                        + "};"
                        + super.toString();
            }

            @Override
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Http1ClientConfig other)) {
                    return false;
                }
                return super.equals(other)
                        && Objects.equals(protocolConfig, other.protocolConfig());
            }

            @Override
            public int hashCode() {
                return 31 * super.hashCode() + Objects.hash(protocolConfig);
            }

        }

    }

    /**
     * Fluent API builder for {@link Http1Client}.
     */
    class Builder extends Http1ClientConfig.BuilderBase<Http1ClientConfig.Builder, Http1ClientConfig> implements io.helidon.common.Builder<Http1ClientConfig.Builder, Http1Client> {

        private Builder() {
        }

        @Override
        public Http1ClientConfig buildPrototype() {
            preBuildPrototype();
            validatePrototype();
            return new Http1ClientConfigImpl(this);
        }

        @Override
        public Http1Client build() {
            return Http1Client.create(this.buildPrototype());
        }

    }

}
