/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webclient.grpc;

import io.helidon.builder.api.Prototype;
import io.helidon.common.Generated;
import io.helidon.common.HelidonServiceLoader;
import io.helidon.common.config.Config;
import io.helidon.common.config.ConfigBuilderSupport;
import io.helidon.webclient.api.HttpClientConfig;
import io.helidon.webclient.grpc.ClientUriSupplier;
import io.helidon.webclient.grpc.GrpcClient;
import io.helidon.webclient.grpc.GrpcClientConfigBlueprint;
import io.helidon.webclient.grpc.GrpcClientProtocolConfig;
import io.helidon.webclient.grpc.spi.GrpcClientService;
import io.helidon.webclient.grpc.spi.GrpcClientServiceProvider;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.function.Consumer;
import java.util.function.Supplier;

@Generated(value="io.helidon.builder.codegen.BuilderCodegen", trigger="io.helidon.webclient.grpc.GrpcClientConfigBlueprint")
public interface GrpcClientConfig
extends GrpcClientConfigBlueprint,
Prototype.Api,
HttpClientConfig {
    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(GrpcClientConfig instance) {
        return (Builder)((Object)GrpcClientConfig.builder().from(instance));
    }

    public static GrpcClientConfig create(Config config) {
        return ((Builder)GrpcClientConfig.builder().config(config)).buildPrototype();
    }

    public static GrpcClientConfig create() {
        return GrpcClientConfig.builder().buildPrototype();
    }

    public static class Builder
    extends BuilderBase<Builder, GrpcClientConfig>
    implements io.helidon.common.Builder<Builder, GrpcClient> {
        private Builder() {
        }

        public GrpcClientConfig buildPrototype() {
            this.preBuildPrototype();
            this.validatePrototype();
            return new BuilderBase.GrpcClientConfigImpl(this);
        }

        public GrpcClient build() {
            return GrpcClient.create(this.buildPrototype());
        }
    }

    public static abstract class BuilderBase<BUILDER extends BuilderBase<BUILDER, PROTOTYPE>, PROTOTYPE extends GrpcClientConfig>
    extends HttpClientConfig.BuilderBase<BUILDER, PROTOTYPE>
    implements ConfigBuilderSupport.ConfiguredBuilder<BUILDER, PROTOTYPE> {
        private final List<GrpcClientService> grpcServices = new ArrayList<GrpcClientService>();
        private boolean enableMetrics = false;
        private boolean grpcServicesDiscoverServices = false;
        private boolean isGrpcServicesMutated;
        private ClientUriSupplier clientUriSupplier;
        private Config config;
        private GrpcClientProtocolConfig protocolConfig = GrpcClientProtocolConfig.create();

        protected BuilderBase() {
        }

        public BUILDER from(GrpcClientConfig prototype) {
            super.from((HttpClientConfig)prototype);
            this.protocolConfig(prototype.protocolConfig());
            this.clientUriSupplier(prototype.clientUriSupplier());
            this.enableMetrics(prototype.enableMetrics());
            if (!this.isGrpcServicesMutated) {
                this.grpcServices.clear();
            }
            this.addGrpcServices(prototype.grpcServices());
            this.grpcServicesDiscoverServices = false;
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        public BUILDER from(BuilderBase<?, ?> builder) {
            super.from(builder);
            this.protocolConfig(builder.protocolConfig());
            builder.clientUriSupplier().ifPresent(this::clientUriSupplier);
            this.enableMetrics(builder.enableMetrics());
            if (this.isGrpcServicesMutated) {
                if (builder.isGrpcServicesMutated) {
                    this.addGrpcServices(builder.grpcServices);
                }
            } else {
                this.grpcServices.clear();
                this.addGrpcServices(builder.grpcServices);
            }
            this.grpcServicesDiscoverServices = builder.grpcServicesDiscoverServices;
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        public BUILDER config(Config config) {
            Objects.requireNonNull(config);
            this.config = config;
            super.config(config);
            config.get("protocol-config").map(GrpcClientProtocolConfig::create).ifPresent(this::protocolConfig);
            config.get("enable-metrics").as(Boolean.class).ifPresent(this::enableMetrics);
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        public BUILDER protocolConfig(GrpcClientProtocolConfig protocolConfig) {
            Objects.requireNonNull(protocolConfig);
            this.protocolConfig = protocolConfig;
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        public BUILDER protocolConfig(Consumer<GrpcClientProtocolConfig.Builder> consumer) {
            Objects.requireNonNull(consumer);
            GrpcClientProtocolConfig.Builder builder = GrpcClientProtocolConfig.builder();
            consumer.accept(builder);
            this.protocolConfig(builder.build());
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        public BUILDER protocolConfig(Supplier<? extends GrpcClientProtocolConfig> supplier) {
            Objects.requireNonNull(supplier);
            this.protocolConfig(supplier.get());
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        public BUILDER clearClientUriSupplier() {
            this.clientUriSupplier = null;
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        public BUILDER clientUriSupplier(ClientUriSupplier clientUriSupplier) {
            Objects.requireNonNull(clientUriSupplier);
            this.clientUriSupplier = clientUriSupplier;
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        public BUILDER enableMetrics(boolean enableMetrics) {
            this.enableMetrics = enableMetrics;
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        public BUILDER grpcServicesDiscoverServices(boolean discoverServices) {
            this.grpcServicesDiscoverServices = discoverServices;
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        public BUILDER grpcServices(List<? extends GrpcClientService> grpcServices) {
            Objects.requireNonNull(grpcServices);
            this.isGrpcServicesMutated = true;
            this.grpcServices.clear();
            this.grpcServices.addAll(grpcServices);
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        public BUILDER addGrpcServices(List<? extends GrpcClientService> grpcServices) {
            Objects.requireNonNull(grpcServices);
            this.isGrpcServicesMutated = true;
            this.grpcServices.addAll(grpcServices);
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        public BUILDER addGrpcService(GrpcClientService grpcService) {
            Objects.requireNonNull(grpcService);
            this.grpcServices.add(grpcService);
            this.isGrpcServicesMutated = true;
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        public GrpcClientProtocolConfig protocolConfig() {
            return this.protocolConfig;
        }

        public Optional<ClientUriSupplier> clientUriSupplier() {
            return Optional.ofNullable(this.clientUriSupplier);
        }

        public boolean enableMetrics() {
            return this.enableMetrics;
        }

        public List<GrpcClientService> grpcServices() {
            return this.grpcServices;
        }

        public Optional<Config> config() {
            return Optional.ofNullable(this.config);
        }

        public String toString() {
            return "GrpcClientConfigBuilder{protocolConfig=" + String.valueOf(this.protocolConfig) + ",clientUriSupplier=" + String.valueOf(this.clientUriSupplier) + ",enableMetrics=" + this.enableMetrics + ",grpcServices=" + String.valueOf(this.grpcServices) + "};" + super.toString();
        }

        protected void preBuildPrototype() {
            super.preBuildPrototype();
            Config config = this.config == null ? Config.empty() : this.config;
            HelidonServiceLoader serviceLoader = HelidonServiceLoader.create(ServiceLoader.load(GrpcClientServiceProvider.class));
            this.addGrpcServices(ConfigBuilderSupport.discoverServices((Config)config, (String)"grpc-services", (HelidonServiceLoader)serviceLoader, GrpcClientServiceProvider.class, GrpcClientService.class, (boolean)this.grpcServicesDiscoverServices, this.grpcServices));
        }

        protected void validatePrototype() {
            super.validatePrototype();
        }

        BUILDER clientUriSupplier(Optional<? extends ClientUriSupplier> clientUriSupplier) {
            Objects.requireNonNull(clientUriSupplier);
            this.clientUriSupplier = clientUriSupplier.map(ClientUriSupplier.class::cast).orElse(this.clientUriSupplier);
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        protected static class GrpcClientConfigImpl
        extends HttpClientConfig.BuilderBase.HttpClientConfigImpl
        implements GrpcClientConfig,
        Supplier<GrpcClient> {
            private final boolean enableMetrics;
            private final GrpcClientProtocolConfig protocolConfig;
            private final List<GrpcClientService> grpcServices;
            private final Optional<ClientUriSupplier> clientUriSupplier;

            protected GrpcClientConfigImpl(BuilderBase<?, ?> builder) {
                super(builder);
                this.protocolConfig = builder.protocolConfig();
                this.clientUriSupplier = builder.clientUriSupplier();
                this.enableMetrics = builder.enableMetrics();
                this.grpcServices = List.copyOf(builder.grpcServices());
            }

            public GrpcClient build() {
                return GrpcClient.create(this);
            }

            @Override
            public GrpcClient get() {
                return this.build();
            }

            @Override
            public GrpcClientProtocolConfig protocolConfig() {
                return this.protocolConfig;
            }

            @Override
            public Optional<ClientUriSupplier> clientUriSupplier() {
                return this.clientUriSupplier;
            }

            @Override
            public boolean enableMetrics() {
                return this.enableMetrics;
            }

            @Override
            public List<GrpcClientService> grpcServices() {
                return this.grpcServices;
            }

            public String toString() {
                return "GrpcClientConfig{protocolConfig=" + String.valueOf(this.protocolConfig) + ",clientUriSupplier=" + String.valueOf(this.clientUriSupplier) + ",enableMetrics=" + this.enableMetrics + ",grpcServices=" + String.valueOf(this.grpcServices) + "};" + super.toString();
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof GrpcClientConfig)) {
                    return false;
                }
                GrpcClientConfig other = (GrpcClientConfig)o;
                return super.equals((Object)other) && Objects.equals(this.protocolConfig, other.protocolConfig()) && Objects.equals(this.clientUriSupplier, other.clientUriSupplier()) && this.enableMetrics == other.enableMetrics() && Objects.equals(this.grpcServices, other.grpcServices());
            }

            public int hashCode() {
                return 31 * super.hashCode() + Objects.hash(this.protocolConfig, this.clientUriSupplier, this.enableMetrics, this.grpcServices);
            }
        }
    }
}

