/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webclient.grpc;

import io.grpc.Channel;
import io.grpc.ClientInterceptor;
import io.grpc.ClientInterceptors;
import io.helidon.webclient.api.WebClient;
import io.helidon.webclient.grpc.GrpcChannel;
import io.helidon.webclient.grpc.GrpcClient;
import io.helidon.webclient.grpc.GrpcClientConfig;
import io.helidon.webclient.grpc.GrpcServiceClient;
import io.helidon.webclient.grpc.GrpcServiceClientImpl;
import io.helidon.webclient.grpc.GrpcServiceDescriptor;
import io.helidon.webclient.http2.Http2Client;

class GrpcClientImpl
implements GrpcClient {
    private final WebClient webClient;
    private final Http2Client http2Client;
    private final GrpcClientConfig clientConfig;

    GrpcClientImpl(WebClient webClient, GrpcClientConfig clientConfig) {
        this.webClient = webClient;
        this.http2Client = (Http2Client)webClient.client(Http2Client.PROTOCOL);
        this.clientConfig = clientConfig;
    }

    WebClient webClient() {
        return this.webClient;
    }

    Http2Client http2Client() {
        return this.http2Client;
    }

    public GrpcClientConfig prototype() {
        return this.clientConfig;
    }

    @Override
    public GrpcServiceClient serviceClient(GrpcServiceDescriptor descriptor) {
        return new GrpcServiceClientImpl(descriptor, this);
    }

    @Override
    public Channel channel() {
        return new GrpcChannel(this);
    }

    @Override
    public Channel channel(ClientInterceptor ... interceptors) {
        return ClientInterceptors.intercept((Channel)this.channel(), (ClientInterceptor[])interceptors);
    }

    @Override
    public GrpcClientConfig clientConfig() {
        return this.clientConfig;
    }
}

