/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webclient.grpc.tracing;

import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.ForwardingClientCall;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.helidon.tracing.HeaderConsumer;
import io.helidon.tracing.Scope;
import io.helidon.tracing.Span;
import io.helidon.tracing.Tracer;
import java.util.List;
import java.util.Optional;

class GrpcClientTracingInterceptor
implements ClientInterceptor {
    private static final System.Logger LOGGER = System.getLogger(GrpcClientTracingInterceptor.class.getName());

    GrpcClientTracingInterceptor() {
    }

    public <ReqT, ResT> ClientCall<ReqT, ResT> interceptCall(final MethodDescriptor<ReqT, ResT> method, CallOptions callOptions, Channel channel) {
        ClientCall call = channel.newCall(method, callOptions);
        return new ForwardingClientCall.SimpleForwardingClientCall<ReqT, ResT>(this, call){
            private Span outgoingClientSpan;
            private Scope outgoingClientScope;

            public void start(ClientCall.Listener<ResT> responseListener, Metadata headers) {
                LOGGER.log(System.Logger.Level.DEBUG, "Call start; metadata: {0}", headers);
                Span.Builder outgoingClientSpanBuilder = Tracer.global().spanBuilder(method.getServiceName() + "-" + method.getFullMethodName()).kind(Span.Kind.CLIENT);
                Span.current().ifPresent(parent -> outgoingClientSpanBuilder.parent(parent.context()));
                this.outgoingClientSpan = outgoingClientSpanBuilder.start();
                try {
                    Tracer.global().inject(this.outgoingClientSpan.context(), null, (HeaderConsumer)new GrpcHeaderConsumer(headers));
                    LOGGER.log(System.Logger.Level.DEBUG, "After injecting span context; metadata: {0}", headers);
                    this.outgoingClientScope = this.outgoingClientSpan.activate();
                    super.start(responseListener, headers);
                }
                catch (Exception e) {
                    this.closeScopeIfActive();
                    this.endSpanIfPresent(e);
                }
            }

            public void halfClose() {
                this.closeScopeIfActive();
                this.endSpanIfPresent(null);
                super.halfClose();
            }

            private void closeScopeIfActive() {
                if (this.outgoingClientScope != null) {
                    this.outgoingClientScope.close();
                    this.outgoingClientScope = null;
                }
            }

            private void endSpanIfPresent(Exception e) {
                if (this.outgoingClientSpan != null) {
                    if (e == null) {
                        this.outgoingClientSpan.end();
                    } else {
                        this.outgoingClientSpan.end((Throwable)e);
                    }
                    this.outgoingClientSpan = null;
                }
            }
        };
    }

    private record GrpcHeaderConsumer(Metadata metadata) implements HeaderConsumer
    {
        public void setIfAbsent(String s, String ... strings) {
            Metadata.Key<String> key = this.key(s);
            if (!this.metadata.containsKey(key)) {
                this.set(key, strings);
            }
        }

        public void set(String s, String ... strings) {
            this.set(this.key(s), strings);
        }

        public Iterable<String> keys() {
            return this.metadata.keys();
        }

        public Optional<String> get(String s) {
            Metadata.Key<String> key = this.key(s);
            return Optional.ofNullable((String)this.metadata.get(key));
        }

        public Iterable<String> getAll(String s) {
            Metadata.Key<String> key = this.key(s);
            return this.metadata.containsKey(key) ? this.metadata.getAll(key) : List.of();
        }

        public boolean contains(String s) {
            return this.metadata.containsKey(this.key(s));
        }

        private Metadata.Key<String> key(String key) {
            return Metadata.Key.of((String)key, (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
        }

        private void set(Metadata.Key<String> key, String ... strings) {
            for (String value : strings) {
                this.metadata.put(key, (Object)value);
            }
        }
    }
}

