/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webclient.context;

import io.helidon.builder.api.Prototype;
import io.helidon.common.Generated;
import io.helidon.common.context.http.ContextRecordConfig;
import io.helidon.config.Config;
import io.helidon.config.ConfigBuilderSupport;
import io.helidon.webclient.context.WebClientContextConfigBlueprint;
import io.helidon.webclient.context.WebClientContextService;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;

@Generated(value="io.helidon.builder.codegen.BuilderCodegen", trigger="io.helidon.webclient.context.WebClientContextConfigBlueprint")
public interface WebClientContextConfig
extends WebClientContextConfigBlueprint,
Prototype.Api {
    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(WebClientContextConfig instance) {
        return (Builder)WebClientContextConfig.builder().from(instance);
    }

    public static WebClientContextConfig create(Config config) {
        return ((Builder)WebClientContextConfig.builder().config(config)).buildPrototype();
    }

    @Deprecated
    public static WebClientContextConfig create(io.helidon.common.config.Config config) {
        return WebClientContextConfig.create(Config.config((io.helidon.common.config.Config)config));
    }

    public static WebClientContextConfig create() {
        return WebClientContextConfig.builder().buildPrototype();
    }

    @Override
    public String name();

    @Override
    public List<ContextRecordConfig> records();

    public static class Builder
    extends BuilderBase<Builder, WebClientContextConfig>
    implements io.helidon.common.Builder<Builder, WebClientContextService> {
        private Builder() {
        }

        public WebClientContextConfig buildPrototype() {
            this.preBuildPrototype();
            this.validatePrototype();
            return new BuilderBase.WebClientContextConfigImpl(this);
        }

        public WebClientContextService build() {
            return WebClientContextService.create(this.buildPrototype());
        }
    }

    public static abstract class BuilderBase<BUILDER extends BuilderBase<BUILDER, PROTOTYPE>, PROTOTYPE extends WebClientContextConfig>
    implements ConfigBuilderSupport.ConfiguredBuilder<BUILDER, PROTOTYPE> {
        private final List<ContextRecordConfig> records = new ArrayList<ContextRecordConfig>();
        private boolean isRecordsMutated;
        private Config config;
        private String name = "context";

        protected BuilderBase() {
        }

        public BUILDER from(WebClientContextConfig prototype) {
            this.name(prototype.name());
            if (!this.isRecordsMutated) {
                this.records.clear();
            }
            this.addRecords(prototype.records());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER from(BuilderBase<?, ?> builder) {
            this.name(builder.name());
            if (this.isRecordsMutated) {
                if (builder.isRecordsMutated) {
                    this.addRecords(builder.records);
                }
            } else {
                this.records.clear();
                this.addRecords(builder.records);
            }
            return (BUILDER)((BuilderBase)this.self());
        }

        @Deprecated
        public BUILDER config(io.helidon.common.config.Config config) {
            return (BUILDER)this.config(Config.config((io.helidon.common.config.Config)config));
        }

        public BUILDER config(Config config) {
            Objects.requireNonNull(config);
            this.config = config;
            config.get("records").asList(ContextRecordConfig::create).ifPresent(this::records);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER name(String name) {
            Objects.requireNonNull(name);
            this.name = name;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER records(List<? extends ContextRecordConfig> records) {
            Objects.requireNonNull(records);
            this.isRecordsMutated = true;
            this.records.clear();
            this.records.addAll(records);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addRecords(List<? extends ContextRecordConfig> records) {
            Objects.requireNonNull(records);
            this.isRecordsMutated = true;
            this.records.addAll(records);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addRecord(ContextRecordConfig record) {
            Objects.requireNonNull(record);
            this.records.add(record);
            this.isRecordsMutated = true;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addRecord(Consumer<ContextRecordConfig.Builder> consumer) {
            Objects.requireNonNull(consumer);
            ContextRecordConfig.Builder builder = ContextRecordConfig.builder();
            consumer.accept(builder);
            this.records.add(builder.build());
            return (BUILDER)((BuilderBase)this.self());
        }

        public String name() {
            return this.name;
        }

        public List<ContextRecordConfig> records() {
            return this.records;
        }

        public Optional<io.helidon.common.config.Config> config() {
            return Optional.ofNullable(this.config);
        }

        public String toString() {
            return "WebClientContextConfigBuilder{name=" + this.name + ",records=" + String.valueOf(this.records) + "}";
        }

        protected void preBuildPrototype() {
        }

        protected void validatePrototype() {
        }

        protected static class WebClientContextConfigImpl
        implements WebClientContextConfig,
        Supplier<WebClientContextService> {
            private final List<ContextRecordConfig> records;
            private final String name;

            protected WebClientContextConfigImpl(BuilderBase<?, ?> builder) {
                this.name = builder.name();
                this.records = List.copyOf(builder.records());
            }

            public WebClientContextService build() {
                return WebClientContextService.create(this);
            }

            @Override
            public WebClientContextService get() {
                return this.build();
            }

            @Override
            public String name() {
                return this.name;
            }

            @Override
            public List<ContextRecordConfig> records() {
                return this.records;
            }

            public String toString() {
                return "WebClientContextConfig{name=" + this.name + ",records=" + String.valueOf(this.records) + "}";
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof WebClientContextConfig)) {
                    return false;
                }
                WebClientContextConfig other = (WebClientContextConfig)o;
                return Objects.equals(this.name, other.name()) && Objects.equals(this.records, other.records());
            }

            public int hashCode() {
                return Objects.hash(this.name, this.records);
            }
        }
    }
}

